@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.AssignmentPrincipalResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.AssignmentPrincipalResponse.Companion.toKotlin as assignmentPrincipalResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.ResourceSetDescriptionResponse.Companion.toKotlin as resourceSetDescriptionResponseToKotlin

/**
 * Builder for [RoleAssignment].
 */
@PulumiTagMarker
public class RoleAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssignmentArgs = RoleAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssignmentArgsBuilder.() -> Unit) {
        val builder = RoleAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.RoleAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoleAssignment(builtJavaResource)
    }
}

/**
 * The Role Assignment resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### RoleAssignments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.CustomerInsights.RoleAssignment("roleAssignment", new()
 *     {
 *         AssignmentName = "assignmentName8976",
 *         HubName = "sdkTestHub",
 *         Principals = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.AssignmentPrincipalArgs
 *             {
 *                 PrincipalId = "4c54c38ffa9b416ba5a6d6c8a20cbe7e",
 *                 PrincipalType = "User",
 *             },
 *             new AzureNative.CustomerInsights.Inputs.AssignmentPrincipalArgs
 *             {
 *                 PrincipalId = "93061d15a5054f2b9948ae25724cf9d5",
 *                 PrincipalType = "User",
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *         Role = AzureNative.CustomerInsights.RoleTypes.Admin,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRoleAssignment(ctx, "roleAssignment", &customerinsights.RoleAssignmentArgs{
 * 			AssignmentName: pulumi.String("assignmentName8976"),
 * 			HubName:        pulumi.String("sdkTestHub"),
 * 			Principals: []customerinsights.AssignmentPrincipalArgs{
 * 				{
 * 					PrincipalId:   pulumi.String("4c54c38ffa9b416ba5a6d6c8a20cbe7e"),
 * 					PrincipalType: pulumi.String("User"),
 * 				},
 * 				{
 * 					PrincipalId:   pulumi.String("93061d15a5054f2b9948ae25724cf9d5"),
 * 					PrincipalType: pulumi.String("User"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			Role:              customerinsights.RoleTypesAdmin,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.RoleAssignment;
 * import com.pulumi.azurenative.customerinsights.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .assignmentName("assignmentName8976")
 *             .hubName("sdkTestHub")
 *             .principals(
 *                 Map.ofEntries(
 *                     Map.entry("principalId", "4c54c38ffa9b416ba5a6d6c8a20cbe7e"),
 *                     Map.entry("principalType", "User")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("principalId", "93061d15a5054f2b9948ae25724cf9d5"),
 *                     Map.entry("principalType", "User")
 *                 ))
 *             .resourceGroupName("TestHubRG")
 *             .role("Admin")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:RoleAssignment azSdkTestHub/assignmentName8976 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}
 * ```
 */
public class RoleAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.RoleAssignment,
) : KotlinCustomResource(javaResource, RoleAssignmentMapper) {
    /**
     * The name of the metadata object.
     */
    public val assignmentName: Output<String>
        get() = javaResource.assignmentName().applyValue({ args0 -> args0 })

    /**
     * Widget types set for the assignment.
     */
    public val conflationPolicies: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.conflationPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceSetDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Connectors set for the assignment.
     */
    public val connectors: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.connectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Localized description for the metadata.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display names for the metadata.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Interactions set for the assignment.
     */
    public val interactions: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.interactions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Kpis set for the assignment.
     */
    public val kpis: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.kpis().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Links set for the assignment.
     */
    public val links: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principals being assigned to.
     */
    public val principals: Output<List<AssignmentPrincipalResponse>>
        get() = javaResource.principals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assignmentPrincipalResponseToKotlin(args0)
                })
            })
        })

    /**
     * Profiles set for the assignment.
     */
    public val profiles: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.profiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The Role assignments set for the relationship links.
     */
    public val relationshipLinks: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.relationshipLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceSetDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Role assignments set for the relationships.
     */
    public val relationships: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.relationships().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceSetDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of roles.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The Role assignments set for the assignment.
     */
    public val roleAssignments: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.roleAssignments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceSetDescriptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sas Policies set for the assignment.
     */
    public val sasPolicies: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.sasPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Role assignments set for the assignment.
     */
    public val segments: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.segments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Views set for the assignment.
     */
    public val views: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.views().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Widget types set for the assignment.
     */
    public val widgetTypes: Output<ResourceSetDescriptionResponse>?
        get() = javaResource.widgetTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object RoleAssignmentMapper : ResourceMapper<RoleAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.RoleAssignment::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssignment = RoleAssignment(
        javaResource as
            com.pulumi.azurenative.customerinsights.RoleAssignment,
    )
}

/**
 * @see [RoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssignment].
 */
public suspend fun roleAssignment(
    name: String,
    block: suspend RoleAssignmentResourceBuilder.() -> Unit,
): RoleAssignment {
    val builder = RoleAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssignment(name: String): RoleAssignment {
    val builder = RoleAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
