@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingFormatArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.FormatTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connector mapping property format.
 * @property acceptLanguage The oData language.
 * @property arraySeparator Character separating array elements.
 * @property columnDelimiter The character that signifies a break between columns.
 * @property formatType The type mapping format.
 * @property quoteCharacter Quote character, used to indicate enquoted fields.
 * @property quoteEscapeCharacter Escape character for quotes, can be the same as the quoteCharacter.
 */
public data class ConnectorMappingFormatArgs(
    public val acceptLanguage: Output<String>? = null,
    public val arraySeparator: Output<String>? = null,
    public val columnDelimiter: Output<String>? = null,
    public val formatType: Output<FormatTypes>,
    public val quoteCharacter: Output<String>? = null,
    public val quoteEscapeCharacter: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingFormatArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingFormatArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .arraySeparator(arraySeparator?.applyValue({ args0 -> args0 }))
            .columnDelimiter(columnDelimiter?.applyValue({ args0 -> args0 }))
            .formatType(formatType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .quoteCharacter(quoteCharacter?.applyValue({ args0 -> args0 }))
            .quoteEscapeCharacter(quoteEscapeCharacter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorMappingFormatArgs].
 */
@PulumiTagMarker
public class ConnectorMappingFormatArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var arraySeparator: Output<String>? = null

    private var columnDelimiter: Output<String>? = null

    private var formatType: Output<FormatTypes>? = null

    private var quoteCharacter: Output<String>? = null

    private var quoteEscapeCharacter: Output<String>? = null

    /**
     * @param value The oData language.
     */
    @JvmName("pioeuvnxcprxftmy")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Character separating array elements.
     */
    @JvmName("bqtskunivkqvpbbh")
    public suspend fun arraySeparator(`value`: Output<String>) {
        this.arraySeparator = value
    }

    /**
     * @param value The character that signifies a break between columns.
     */
    @JvmName("ouktkuvttpotwnev")
    public suspend fun columnDelimiter(`value`: Output<String>) {
        this.columnDelimiter = value
    }

    /**
     * @param value The type mapping format.
     */
    @JvmName("wtvyefpxmacjuvdy")
    public suspend fun formatType(`value`: Output<FormatTypes>) {
        this.formatType = value
    }

    /**
     * @param value Quote character, used to indicate enquoted fields.
     */
    @JvmName("ndaxggpssmjtvkgp")
    public suspend fun quoteCharacter(`value`: Output<String>) {
        this.quoteCharacter = value
    }

    /**
     * @param value Escape character for quotes, can be the same as the quoteCharacter.
     */
    @JvmName("pwhjxtkcdjulgocj")
    public suspend fun quoteEscapeCharacter(`value`: Output<String>) {
        this.quoteEscapeCharacter = value
    }

    /**
     * @param value The oData language.
     */
    @JvmName("iydwavqxoqwotmga")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Character separating array elements.
     */
    @JvmName("rlbjbctutstjijow")
    public suspend fun arraySeparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arraySeparator = mapped
    }

    /**
     * @param value The character that signifies a break between columns.
     */
    @JvmName("ucpthkhkspkpjhop")
    public suspend fun columnDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnDelimiter = mapped
    }

    /**
     * @param value The type mapping format.
     */
    @JvmName("oxngeducxavqojit")
    public suspend fun formatType(`value`: FormatTypes) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formatType = mapped
    }

    /**
     * @param value Quote character, used to indicate enquoted fields.
     */
    @JvmName("estlmkeqoadorsrf")
    public suspend fun quoteCharacter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteCharacter = mapped
    }

    /**
     * @param value Escape character for quotes, can be the same as the quoteCharacter.
     */
    @JvmName("cqnjojuyowxndygl")
    public suspend fun quoteEscapeCharacter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteEscapeCharacter = mapped
    }

    internal fun build(): ConnectorMappingFormatArgs = ConnectorMappingFormatArgs(
        acceptLanguage = acceptLanguage,
        arraySeparator = arraySeparator,
        columnDelimiter = columnDelimiter,
        formatType = formatType ?: throw PulumiNullFieldException("formatType"),
        quoteCharacter = quoteCharacter,
        quoteEscapeCharacter = quoteEscapeCharacter,
    )
}
