@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetHubPlainArgs(
    public val hubName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetHubPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetHubPlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHubPlainArgs].
 */
@PulumiTagMarker
public class GetHubPlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("fittveavtewfwywo")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qeohrrmwknmacqan")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHubPlainArgs = GetHubPlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
