@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hubName The name of the hub.
 * @property localeCode Locale of profile to retrieve, default is en-us.
 * @property profileName The name of the profile.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetProfilePlainArgs(
    public val hubName: String,
    public val localeCode: String? = null,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetProfilePlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetProfilePlainArgs.builder()
            .hubName(hubName.let({ args0 -> args0 }))
            .localeCode(localeCode?.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProfilePlainArgs].
 */
@PulumiTagMarker
public class GetProfilePlainArgsBuilder internal constructor() {
    private var hubName: String? = null

    private var localeCode: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the hub.
     */
    @JvmName("wgoqedgenixjdcnf")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value Locale of profile to retrieve, default is en-us.
     */
    @JvmName("lotaeyadcrocownx")
    public suspend fun localeCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localeCode = mapped
    }

    /**
     * @param value The name of the profile.
     */
    @JvmName("cbbcgwripynykkih")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xoljarepouwtyeoo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProfilePlainArgs = GetProfilePlainArgs(
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        localeCode = localeCode,
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
