@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.KpiAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The KPI alias.
 * @property aliasName KPI alias name.
 * @property expression The expression.
 */
public data class KpiAliasArgs(
    public val aliasName: Output<String>,
    public val expression: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.KpiAliasArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.KpiAliasArgs =
        com.pulumi.azurenative.customerinsights.inputs.KpiAliasArgs.builder()
            .aliasName(aliasName.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KpiAliasArgs].
 */
@PulumiTagMarker
public class KpiAliasArgsBuilder internal constructor() {
    private var aliasName: Output<String>? = null

    private var expression: Output<String>? = null

    /**
     * @param value KPI alias name.
     */
    @JvmName("xmrvwihmgdtajous")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value The expression.
     */
    @JvmName("ihieshixqnklthtt")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value KPI alias name.
     */
    @JvmName("uvkvxhwrhhxtwaup")
    public suspend fun aliasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value The expression.
     */
    @JvmName("mpudjqjmotgusqca")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    internal fun build(): KpiAliasArgs = KpiAliasArgs(
        aliasName = aliasName ?: throw PulumiNullFieldException("aliasName"),
        expression = expression ?: throw PulumiNullFieldException("expression"),
    )
}
