@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connector mapping property format.
 * @property acceptLanguage The oData language.
 * @property arraySeparator Character separating array elements.
 * @property columnDelimiter The character that signifies a break between columns.
 * @property formatType The type mapping format.
 * @property quoteCharacter Quote character, used to indicate enquoted fields.
 * @property quoteEscapeCharacter Escape character for quotes, can be the same as the quoteCharacter.
 */
public data class ConnectorMappingFormatResponse(
    public val acceptLanguage: String? = null,
    public val arraySeparator: String? = null,
    public val columnDelimiter: String? = null,
    public val formatType: String,
    public val quoteCharacter: String? = null,
    public val quoteEscapeCharacter: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.ConnectorMappingFormatResponse):
            ConnectorMappingFormatResponse = ConnectorMappingFormatResponse(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            arraySeparator = javaType.arraySeparator().map({ args0 -> args0 }).orElse(null),
            columnDelimiter = javaType.columnDelimiter().map({ args0 -> args0 }).orElse(null),
            formatType = javaType.formatType(),
            quoteCharacter = javaType.quoteCharacter().map({ args0 -> args0 }).orElse(null),
            quoteEscapeCharacter = javaType.quoteEscapeCharacter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
