@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The prediction model status.
 * @property message The model status message.
 * @property modelVersion Version of the model.
 * @property predictionGuidId The prediction GUID ID.
 * @property predictionName The prediction name.
 * @property signalsUsed The signals used.
 * @property status Prediction model life cycle.  When prediction is in PendingModelConfirmation status, it is allowed to update the status to PendingFeaturing or Active through API.
 * @property tenantId The hub name.
 * @property testSetCount Count of the test set.
 * @property trainingAccuracy The training accuracy.
 * @property trainingSetCount Count of the training set.
 * @property validationSetCount Count of the validation set.
 */
public data class GetPredictionModelStatusResult(
    public val message: String,
    public val modelVersion: String,
    public val predictionGuidId: String,
    public val predictionName: String,
    public val signalsUsed: Int,
    public val status: String,
    public val tenantId: String,
    public val testSetCount: Int,
    public val trainingAccuracy: Int,
    public val trainingSetCount: Int,
    public val validationSetCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetPredictionModelStatusResult):
            GetPredictionModelStatusResult = GetPredictionModelStatusResult(
            message = javaType.message(),
            modelVersion = javaType.modelVersion(),
            predictionGuidId = javaType.predictionGuidId(),
            predictionName = javaType.predictionName(),
            signalsUsed = javaType.signalsUsed(),
            status = javaType.status(),
            tenantId = javaType.tenantId(),
            testSetCount = javaType.testSetCount(),
            trainingAccuracy = javaType.trainingAccuracy(),
            trainingSetCount = javaType.trainingSetCount(),
            validationSetCount = javaType.validationSetCount(),
        )
    }
}
