@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The training results of the prediction.
 * @property canonicalProfiles Canonical profiles.
 * @property predictionDistribution Prediction distribution.
 * @property primaryProfileInstanceCount Instance count of the primary profile.
 * @property scoreName Score name.
 * @property tenantId The hub name.
 */
public data class GetPredictionTrainingResultsResult(
    public val canonicalProfiles: List<CanonicalProfileDefinitionResponse>,
    public val predictionDistribution: PredictionDistributionDefinitionResponse,
    public val primaryProfileInstanceCount: Double,
    public val scoreName: String,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.GetPredictionTrainingResultsResult):
            GetPredictionTrainingResultsResult = GetPredictionTrainingResultsResult(
            canonicalProfiles = javaType.canonicalProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.customerinsights.kotlin.outputs.CanonicalProfileDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            predictionDistribution = javaType.predictionDistribution().let({ args0 ->
                com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionDistributionDefinitionResponse.Companion.toKotlin(args0)
            }),
            primaryProfileInstanceCount = javaType.primaryProfileInstanceCount(),
            scoreName = javaType.scoreName(),
            tenantId = javaType.tenantId(),
        )
    }
}
