@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata for a Link's property mapping.
 * @property linkType Link type.
 * @property sourcePropertyName  Property name on the source Entity Type.
 * @property targetPropertyName Property name on the target Entity Type.
 */
public data class TypePropertiesMappingResponse(
    public val linkType: String? = null,
    public val sourcePropertyName: String,
    public val targetPropertyName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.TypePropertiesMappingResponse):
            TypePropertiesMappingResponse = TypePropertiesMappingResponse(
            linkType = javaType.linkType().map({ args0 -> args0 }).orElse(null),
            sourcePropertyName = javaType.sourcePropertyName(),
            targetPropertyName = javaType.targetPropertyName(),
        )
    }
}
