@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin

import com.pulumi.azurenative.customproviders.CustomResourceProviderArgs.builder
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPActionRouteDefinitionArgs
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPActionRouteDefinitionArgsBuilder
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPResourceTypeRouteDefinitionArgs
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPResourceTypeRouteDefinitionArgsBuilder
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPValidationsArgs
import com.pulumi.azurenative.customproviders.kotlin.inputs.CustomRPValidationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A manifest file that defines the custom resource provider resources.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update the custom resource provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customResourceProvider = new AzureNative.CustomProviders.CustomResourceProvider("customResourceProvider", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.CustomProviders.Inputs.CustomRPActionRouteDefinitionArgs
 *             {
 *                 Endpoint = "https://mytestendpoint/",
 *                 Name = "TestAction",
 *                 RoutingType = "Proxy",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "testRG",
 *         ResourceProviderName = "newrp",
 *         ResourceTypes = new[]
 *         {
 *             new AzureNative.CustomProviders.Inputs.CustomRPResourceTypeRouteDefinitionArgs
 *             {
 *                 Endpoint = "https://mytestendpoint2/",
 *                 Name = "TestResource",
 *                 RoutingType = "Proxy,Cache",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customproviders/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customproviders.NewCustomResourceProvider(ctx, "customResourceProvider", &customproviders.CustomResourceProviderArgs{
 * 			Actions: []customproviders.CustomRPActionRouteDefinitionArgs{
 * 				{
 * 					Endpoint:    pulumi.String("https://mytestendpoint/"),
 * 					Name:        pulumi.String("TestAction"),
 * 					RoutingType: pulumi.String("Proxy"),
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("testRG"),
 * 			ResourceProviderName: pulumi.String("newrp"),
 * 			ResourceTypes: []customproviders.CustomRPResourceTypeRouteDefinitionArgs{
 * 				{
 * 					Endpoint:    pulumi.String("https://mytestendpoint2/"),
 * 					Name:        pulumi.String("TestResource"),
 * 					RoutingType: pulumi.String("Proxy,Cache"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customproviders.CustomResourceProvider;
 * import com.pulumi.azurenative.customproviders.CustomResourceProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customResourceProvider = new CustomResourceProvider("customResourceProvider", CustomResourceProviderArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("endpoint", "https://mytestendpoint/"),
 *                 Map.entry("name", "TestAction"),
 *                 Map.entry("routingType", "Proxy")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("testRG")
 *             .resourceProviderName("newrp")
 *             .resourceTypes(Map.ofEntries(
 *                 Map.entry("endpoint", "https://mytestendpoint2/"),
 *                 Map.entry("name", "TestResource"),
 *                 Map.entry("routingType", "Proxy,Cache")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customproviders:CustomResourceProvider newrp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}
 * ```
 * @property actions A list of actions that the custom resource provider implements.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property resourceProviderName The name of the resource provider.
 * @property resourceTypes A list of resource types that the custom resource provider implements.
 * @property tags Resource tags
 * @property validations A list of validations to run on the custom resource provider's requests.
 */
public data class CustomResourceProviderArgs(
    public val actions: Output<List<CustomRPActionRouteDefinitionArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceProviderName: Output<String>? = null,
    public val resourceTypes: Output<List<CustomRPResourceTypeRouteDefinitionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validations: Output<List<CustomRPValidationsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customproviders.CustomResourceProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.customproviders.CustomResourceProviderArgs =
        com.pulumi.azurenative.customproviders.CustomResourceProviderArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceProviderName(resourceProviderName?.applyValue({ args0 -> args0 }))
            .resourceTypes(
                resourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validations(
                validations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomResourceProviderArgs].
 */
@PulumiTagMarker
public class CustomResourceProviderArgsBuilder internal constructor() {
    private var actions: Output<List<CustomRPActionRouteDefinitionArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceProviderName: Output<String>? = null

    private var resourceTypes: Output<List<CustomRPResourceTypeRouteDefinitionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validations: Output<List<CustomRPValidationsArgs>>? = null

    /**
     * @param value A list of actions that the custom resource provider implements.
     */
    @JvmName("hlxhycxhtqoaitep")
    public suspend fun actions(`value`: Output<List<CustomRPActionRouteDefinitionArgs>>) {
        this.actions = value
    }

    @JvmName("xogevsyqjpuhnpvs")
    public suspend fun actions(vararg values: Output<CustomRPActionRouteDefinitionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values A list of actions that the custom resource provider implements.
     */
    @JvmName("nxqdirhwwtlvwful")
    public suspend fun actions(values: List<Output<CustomRPActionRouteDefinitionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("rmhxhiblmeavmtys")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("inspbhprxknbopfj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource provider.
     */
    @JvmName("bigbtsweqsiswlpd")
    public suspend fun resourceProviderName(`value`: Output<String>) {
        this.resourceProviderName = value
    }

    /**
     * @param value A list of resource types that the custom resource provider implements.
     */
    @JvmName("apywnbcpwdsyvblk")
    public suspend fun resourceTypes(`value`: Output<List<CustomRPResourceTypeRouteDefinitionArgs>>) {
        this.resourceTypes = value
    }

    @JvmName("afxkfqasgqgpgodf")
    public suspend fun resourceTypes(vararg values: Output<CustomRPResourceTypeRouteDefinitionArgs>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types that the custom resource provider implements.
     */
    @JvmName("lfakrehfmrriailf")
    public suspend fun resourceTypes(values: List<Output<CustomRPResourceTypeRouteDefinitionArgs>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Resource tags
     */
    @JvmName("alwcbhaumjfamghb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("ruakbsdcdnumvten")
    public suspend fun validations(`value`: Output<List<CustomRPValidationsArgs>>) {
        this.validations = value
    }

    @JvmName("fhnyciapvguietvv")
    public suspend fun validations(vararg values: Output<CustomRPValidationsArgs>) {
        this.validations = Output.all(values.asList())
    }

    /**
     * @param values A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("imjxkjhqpsdbnlop")
    public suspend fun validations(values: List<Output<CustomRPValidationsArgs>>) {
        this.validations = Output.all(values)
    }

    /**
     * @param value A list of actions that the custom resource provider implements.
     */
    @JvmName("lrimljeeiebikdpy")
    public suspend fun actions(`value`: List<CustomRPActionRouteDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument A list of actions that the custom resource provider implements.
     */
    @JvmName("ftedcgmelawrfcaj")
    public suspend
    fun actions(argument: List<suspend CustomRPActionRouteDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRPActionRouteDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument A list of actions that the custom resource provider implements.
     */
    @JvmName("hlttnvjgarqjjlgv")
    public suspend fun actions(
        vararg
        argument: suspend CustomRPActionRouteDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRPActionRouteDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument A list of actions that the custom resource provider implements.
     */
    @JvmName("unewrkbpkxixtcnq")
    public suspend
    fun actions(argument: suspend CustomRPActionRouteDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomRPActionRouteDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values A list of actions that the custom resource provider implements.
     */
    @JvmName("uyyaeoimqwaxhobf")
    public suspend fun actions(vararg values: CustomRPActionRouteDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("nchnamisdyeufnxf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pkwxlemostuhdhgp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource provider.
     */
    @JvmName("boxtutoadmxxoumd")
    public suspend fun resourceProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderName = mapped
    }

    /**
     * @param value A list of resource types that the custom resource provider implements.
     */
    @JvmName("wtvpmyeygcmlkivg")
    public suspend fun resourceTypes(`value`: List<CustomRPResourceTypeRouteDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param argument A list of resource types that the custom resource provider implements.
     */
    @JvmName("lmcbkrqujanknwhn")
    public suspend
    fun resourceTypes(argument: List<suspend CustomRPResourceTypeRouteDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRPResourceTypeRouteDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument A list of resource types that the custom resource provider implements.
     */
    @JvmName("htknjgbuetwvxsyd")
    public suspend fun resourceTypes(
        vararg
        argument: suspend CustomRPResourceTypeRouteDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRPResourceTypeRouteDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument A list of resource types that the custom resource provider implements.
     */
    @JvmName("vhnglsetwqtesfhw")
    public suspend
    fun resourceTypes(argument: suspend CustomRPResourceTypeRouteDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomRPResourceTypeRouteDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param values A list of resource types that the custom resource provider implements.
     */
    @JvmName("wltlxxqionjlqqjn")
    public suspend fun resourceTypes(vararg values: CustomRPResourceTypeRouteDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("dhlsqklkdbgquevi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("masjvcskoicpvanf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("bqdlqwlqdxrcllur")
    public suspend fun validations(`value`: List<CustomRPValidationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validations = mapped
    }

    /**
     * @param argument A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("bykgvnqshgwtawke")
    public suspend
    fun validations(argument: List<suspend CustomRPValidationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRPValidationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validations = mapped
    }

    /**
     * @param argument A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("dpyhiusyvcstfurr")
    public suspend fun validations(
        vararg
        argument: suspend CustomRPValidationsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRPValidationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validations = mapped
    }

    /**
     * @param argument A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("dqbwuynxbwjkbmkc")
    public suspend fun validations(argument: suspend CustomRPValidationsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomRPValidationsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.validations = mapped
    }

    /**
     * @param values A list of validations to run on the custom resource provider's requests.
     */
    @JvmName("jowqxciblwocmgjk")
    public suspend fun validations(vararg values: CustomRPValidationsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validations = mapped
    }

    internal fun build(): CustomResourceProviderArgs = CustomResourceProviderArgs(
        actions = actions,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceProviderName = resourceProviderName,
        resourceTypes = resourceTypes,
        tags = tags,
        validations = validations,
    )
}
