@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The route definition for an action implemented by the custom resource provider.
 * @property endpoint The route definition endpoint URI that the custom resource provider will proxy requests to. This can be in the form of a flat URI (e.g. 'https://testendpoint/') or can specify to route via a path (e.g. 'https://testendpoint/{requestPath}')
 * @property name The name of the route definition. This becomes the name for the ARM extension (e.g. '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomProviders/resourceProviders/{resourceProviderName}/{name}')
 * @property routingType The routing types that are supported for action requests.
 */
public data class CustomRPActionRouteDefinitionResponse(
    public val endpoint: String,
    public val name: String,
    public val routingType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customproviders.outputs.CustomRPActionRouteDefinitionResponse):
            CustomRPActionRouteDefinitionResponse = CustomRPActionRouteDefinitionResponse(
            endpoint = javaType.endpoint(),
            name = javaType.name(),
            routingType = javaType.routingType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
