@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin

import com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The managed private endpoint resource type.
 * Azure REST API version: 2022-10-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### ManagedPrivateEndpoint_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.Dashboard.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         GroupIds = new[]
 *         {
 *             "grafana",
 *         },
 *         Location = "West US",
 *         ManagedPrivateEndpointName = "myMPEName",
 *         PrivateLinkResourceId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource",
 *         PrivateLinkResourceRegion = "West US",
 *         PrivateLinkServiceUrl = "my-self-hosted-influxdb.westus.mydomain.com",
 *         RequestMessage = "Example Request Message",
 *         ResourceGroupName = "myResourceGroup",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dashboard/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dashboard.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &dashboard.ManagedPrivateEndpointArgs{
 * 			GroupIds: pulumi.StringArray{
 * 				pulumi.String("grafana"),
 * 			},
 * 			Location:                   pulumi.String("West US"),
 * 			ManagedPrivateEndpointName: pulumi.String("myMPEName"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource"),
 * 			PrivateLinkResourceRegion:  pulumi.String("West US"),
 * 			PrivateLinkServiceUrl:      pulumi.String("my-self-hosted-influxdb.westus.mydomain.com"),
 * 			RequestMessage:             pulumi.String("Example Request Message"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			WorkspaceName:              pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .groupIds("grafana")
 *             .location("West US")
 *             .managedPrivateEndpointName("myMPEName")
 *             .privateLinkResourceId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource")
 *             .privateLinkResourceRegion("West US")
 *             .privateLinkServiceUrl("my-self-hosted-influxdb.westus.mydomain.com")
 *             .requestMessage("Example Request Message")
 *             .resourceGroupName("myResourceGroup")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dashboard:ManagedPrivateEndpoint myMPEName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 * @property groupIds The group Ids of the managed private endpoint.
 * @property location The geo-location where the resource lives
 * @property managedPrivateEndpointName The managed private endpoint name of Azure Managed Grafana.
 * @property privateLinkResourceId The ARM resource ID of the resource for which the managed private endpoint is pointing to.
 * @property privateLinkResourceRegion The region of the resource to which the managed private endpoint is pointing to.
 * @property privateLinkServiceUrl The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port.
 * @property requestMessage User input request message of the managed private endpoint.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workspaceName The workspace name of Azure Managed Grafana.
 */
public data class ManagedPrivateEndpointArgs(
    public val groupIds: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val managedPrivateEndpointName: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val privateLinkResourceRegion: Output<String>? = null,
    public val privateLinkServiceUrl: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs =
        com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedPrivateEndpointName(managedPrivateEndpointName?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceRegion(privateLinkResourceRegion?.applyValue({ args0 -> args0 }))
            .privateLinkServiceUrl(privateLinkServiceUrl?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrivateEndpointArgs].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var managedPrivateEndpointName: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var privateLinkResourceRegion: Output<String>? = null

    private var privateLinkServiceUrl: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The group Ids of the managed private endpoint.
     */
    @JvmName("tcoitskweetmllnd")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("nshgwrbfjhsbjqrr")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The group Ids of the managed private endpoint.
     */
    @JvmName("yjurbyxlwtnbsoae")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lvlpckkyacmobrmk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The managed private endpoint name of Azure Managed Grafana.
     */
    @JvmName("hgoqldmujybfyywv")
    public suspend fun managedPrivateEndpointName(`value`: Output<String>) {
        this.managedPrivateEndpointName = value
    }

    /**
     * @param value The ARM resource ID of the resource for which the managed private endpoint is pointing to.
     */
    @JvmName("grcespmwnnoymwpj")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The region of the resource to which the managed private endpoint is pointing to.
     */
    @JvmName("cdetdjyaaekayggj")
    public suspend fun privateLinkResourceRegion(`value`: Output<String>) {
        this.privateLinkResourceRegion = value
    }

    /**
     * @param value The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port.
     */
    @JvmName("semecnsmnewthpel")
    public suspend fun privateLinkServiceUrl(`value`: Output<String>) {
        this.privateLinkServiceUrl = value
    }

    /**
     * @param value User input request message of the managed private endpoint.
     */
    @JvmName("djhgeycmgdehwphm")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kixsyljnelqpqbls")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kqyvlceeulcgmmim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("jeckpertxepmkaxh")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The group Ids of the managed private endpoint.
     */
    @JvmName("kfnlcaaottjovyet")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The group Ids of the managed private endpoint.
     */
    @JvmName("umicaiwplquwrrck")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bjoangvixpofqmsx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The managed private endpoint name of Azure Managed Grafana.
     */
    @JvmName("jpeyxibcbilybgew")
    public suspend fun managedPrivateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value The ARM resource ID of the resource for which the managed private endpoint is pointing to.
     */
    @JvmName("voknvvdkmseuhcge")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The region of the resource to which the managed private endpoint is pointing to.
     */
    @JvmName("hwffpxhjmiemrddr")
    public suspend fun privateLinkResourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceRegion = mapped
    }

    /**
     * @param value The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port.
     */
    @JvmName("topxaiemvbrknwns")
    public suspend fun privateLinkServiceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceUrl = mapped
    }

    /**
     * @param value User input request message of the managed private endpoint.
     */
    @JvmName("gpynjakvnhdcfpoh")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jpneiqlueqroyqkh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mylorevstnulweca")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dddpfnsurkovylon")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("ynyksjfcaygibqty")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs(
        groupIds = groupIds,
        location = location,
        managedPrivateEndpointName = managedPrivateEndpointName,
        privateLinkResourceId = privateLinkResourceId,
        privateLinkResourceRegion = privateLinkResourceRegion,
        privateLinkServiceUrl = privateLinkServiceUrl,
        requestMessage = requestMessage,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
