@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.GetGrafanaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The workspace name of Azure Managed Grafana.
 */
public data class GetGrafanaPlainArgs(
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.GetGrafanaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.inputs.GetGrafanaPlainArgs =
        com.pulumi.azurenative.dashboard.inputs.GetGrafanaPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGrafanaPlainArgs].
 */
@PulumiTagMarker
public class GetGrafanaPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iypsqjrogpbykomq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workspace name of Azure Managed Grafana.
     */
    @JvmName("vtrgrvgmykntfolb")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetGrafanaPlainArgs = GetGrafanaPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
