@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.ManagedGrafanaPropertiesArgs.builder
import com.pulumi.azurenative.dashboard.kotlin.enums.ApiKey
import com.pulumi.azurenative.dashboard.kotlin.enums.AutoGeneratedDomainNameLabelScope
import com.pulumi.azurenative.dashboard.kotlin.enums.DeterministicOutboundIP
import com.pulumi.azurenative.dashboard.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.dashboard.kotlin.enums.ZoneRedundancy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties specific to the grafana resource.
 * @property apiKey The api key setting of the Grafana instance.
 * @property autoGeneratedDomainNameLabelScope Scope for dns deterministic name hash calculation.
 * @property deterministicOutboundIP Whether a Grafana instance uses deterministic outbound IPs.
 * @property grafanaIntegrations GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
 * @property publicNetworkAccess Indicate the state for enable or disable traffic over the public interface.
 * @property zoneRedundancy The zone redundancy setting of the Grafana instance.
 */
public data class ManagedGrafanaPropertiesArgs(
    public val apiKey: Output<Either<String, ApiKey>>? = null,
    public val autoGeneratedDomainNameLabelScope:
    Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null,
    public val deterministicOutboundIP: Output<Either<String, DeterministicOutboundIP>>? = null,
    public val grafanaIntegrations: Output<GrafanaIntegrationsArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.ManagedGrafanaPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.inputs.ManagedGrafanaPropertiesArgs =
        com.pulumi.azurenative.dashboard.inputs.ManagedGrafanaPropertiesArgs.builder()
            .apiKey(
                apiKey?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoGeneratedDomainNameLabelScope(
                autoGeneratedDomainNameLabelScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .deterministicOutboundIP(
                deterministicOutboundIP?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .grafanaIntegrations(
                grafanaIntegrations?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .zoneRedundancy(
                zoneRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedGrafanaPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedGrafanaPropertiesArgsBuilder internal constructor() {
    private var apiKey: Output<Either<String, ApiKey>>? = null

    private var autoGeneratedDomainNameLabelScope:
        Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null

    private var deterministicOutboundIP: Output<Either<String, DeterministicOutboundIP>>? = null

    private var grafanaIntegrations: Output<GrafanaIntegrationsArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null

    /**
     * @param value The api key setting of the Grafana instance.
     */
    @JvmName("ykpaijheikxsaowp")
    public suspend fun apiKey(`value`: Output<Either<String, ApiKey>>) {
        this.apiKey = value
    }

    /**
     * @param value Scope for dns deterministic name hash calculation.
     */
    @JvmName("shtlymlxfdttwing")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Output<Either<String, AutoGeneratedDomainNameLabelScope>>) {
        this.autoGeneratedDomainNameLabelScope = value
    }

    /**
     * @param value Whether a Grafana instance uses deterministic outbound IPs.
     */
    @JvmName("vngmgebsoftbwlyr")
    public suspend
    fun deterministicOutboundIP(`value`: Output<Either<String, DeterministicOutboundIP>>) {
        this.deterministicOutboundIP = value
    }

    /**
     * @param value GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
     */
    @JvmName("navkldxiuvkmulfi")
    public suspend fun grafanaIntegrations(`value`: Output<GrafanaIntegrationsArgs>) {
        this.grafanaIntegrations = value
    }

    /**
     * @param value Indicate the state for enable or disable traffic over the public interface.
     */
    @JvmName("wbtblmsrelljrtjg")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The zone redundancy setting of the Grafana instance.
     */
    @JvmName("irxsiabhpxhwlhpk")
    public suspend fun zoneRedundancy(`value`: Output<Either<String, ZoneRedundancy>>) {
        this.zoneRedundancy = value
    }

    /**
     * @param value The api key setting of the Grafana instance.
     */
    @JvmName("wkycguufyiotsmok")
    public suspend fun apiKey(`value`: Either<String, ApiKey>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The api key setting of the Grafana instance.
     */
    @JvmName("lgrduknufqkucuqd")
    public fun apiKey(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApiKey>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The api key setting of the Grafana instance.
     */
    @JvmName("pceplsithrrorlsa")
    public fun apiKey(`value`: ApiKey) {
        val toBeMapped = Either.ofRight<String, ApiKey>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value Scope for dns deterministic name hash calculation.
     */
    @JvmName("hnqluhywlosvskex")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Either<String, AutoGeneratedDomainNameLabelScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Scope for dns deterministic name hash calculation.
     */
    @JvmName("bvqtabjiymgudqwk")
    public fun autoGeneratedDomainNameLabelScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Scope for dns deterministic name hash calculation.
     */
    @JvmName("plkfxbuurgypxjgq")
    public fun autoGeneratedDomainNameLabelScope(`value`: AutoGeneratedDomainNameLabelScope) {
        val toBeMapped = Either.ofRight<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Whether a Grafana instance uses deterministic outbound IPs.
     */
    @JvmName("kibltjekavyaotfx")
    public suspend fun deterministicOutboundIP(`value`: Either<String, DeterministicOutboundIP>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deterministicOutboundIP = mapped
    }

    /**
     * @param value Whether a Grafana instance uses deterministic outbound IPs.
     */
    @JvmName("dhgofbqtojlbrpyx")
    public fun deterministicOutboundIP(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeterministicOutboundIP>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deterministicOutboundIP = mapped
    }

    /**
     * @param value Whether a Grafana instance uses deterministic outbound IPs.
     */
    @JvmName("ywvrrirehslvvvpj")
    public fun deterministicOutboundIP(`value`: DeterministicOutboundIP) {
        val toBeMapped = Either.ofRight<String, DeterministicOutboundIP>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deterministicOutboundIP = mapped
    }

    /**
     * @param value GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
     */
    @JvmName("ntggtymdohpcluxy")
    public suspend fun grafanaIntegrations(`value`: GrafanaIntegrationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaIntegrations = mapped
    }

    /**
     * @param argument GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source, tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.
     */
    @JvmName("mveuxsgmsciylpfh")
    public suspend
    fun grafanaIntegrations(argument: suspend GrafanaIntegrationsArgsBuilder.() -> Unit) {
        val toBeMapped = GrafanaIntegrationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.grafanaIntegrations = mapped
    }

    /**
     * @param value Indicate the state for enable or disable traffic over the public interface.
     */
    @JvmName("jtrphculagxvddji")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicate the state for enable or disable traffic over the public interface.
     */
    @JvmName("kwwsbsgmahrcyeto")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicate the state for enable or disable traffic over the public interface.
     */
    @JvmName("nnbqdbhmmcmtgpwn")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The zone redundancy setting of the Grafana instance.
     */
    @JvmName("kxcndvsbkymxlgys")
    public suspend fun zoneRedundancy(`value`: Either<String, ZoneRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value The zone redundancy setting of the Grafana instance.
     */
    @JvmName("ywjnylpvuumntlxp")
    public fun zoneRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value The zone redundancy setting of the Grafana instance.
     */
    @JvmName("cpkkkpcujjeciaot")
    public fun zoneRedundancy(`value`: ZoneRedundancy) {
        val toBeMapped = Either.ofRight<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    internal fun build(): ManagedGrafanaPropertiesArgs = ManagedGrafanaPropertiesArgs(
        apiKey = apiKey,
        autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope,
        deterministicOutboundIP = deterministicOutboundIP,
        grafanaIntegrations = grafanaIntegrations,
        publicNetworkAccess = publicNetworkAccess,
        zoneRedundancy = zoneRedundancy,
    )
}
