@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin.inputs

import com.pulumi.azurenative.dashboard.inputs.ResourceSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name
 */
public data class ResourceSkuArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.dashboard.inputs.ResourceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.dashboard.inputs.ResourceSkuArgs =
        com.pulumi.azurenative.dashboard.inputs.ResourceSkuArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSkuArgs].
 */
@PulumiTagMarker
public class ResourceSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("scaubuvvujpeylrn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("eopcyjiwjqbehgoh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ResourceSkuArgs = ResourceSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
