@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SharedPrivateLinkResource].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SharedPrivateLinkResourceArgs = SharedPrivateLinkResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SharedPrivateLinkResourceArgsBuilder.() -> Unit) {
        val builder = SharedPrivateLinkResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SharedPrivateLinkResource {
        val builtJavaResource =
            com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SharedPrivateLinkResource(builtJavaResource)
    }
}

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### SharedPrivateLinkResources_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sharedPrivateLinkResource = new AzureNative.DatabaseWatcher.SharedPrivateLinkResource("sharedPrivateLinkResource", new()
 *     {
 *         DnsZone = "ec3ae9d410ba",
 *         GroupId = "vault",
 *         PrivateLinkResourceId = "/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih",
 *         RequestMessage = "request message",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         SharedPrivateLinkResourceName = "monitoringh22eed",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewSharedPrivateLinkResource(ctx, "sharedPrivateLinkResource", &databasewatcher.SharedPrivateLinkResourceArgs{
 * 			DnsZone:                       pulumi.String("ec3ae9d410ba"),
 * 			GroupId:                       pulumi.String("vault"),
 * 			PrivateLinkResourceId:         pulumi.String("/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih"),
 * 			RequestMessage:                pulumi.String("request message"),
 * 			ResourceGroupName:             pulumi.String("apiTest-ddat4p"),
 * 			SharedPrivateLinkResourceName: pulumi.String("monitoringh22eed"),
 * 			WatcherName:                   pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource;
 * import com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sharedPrivateLinkResource = new SharedPrivateLinkResource("sharedPrivateLinkResource", SharedPrivateLinkResourceArgs.builder()
 *             .dnsZone("ec3ae9d410ba")
 *             .groupId("vault")
 *             .privateLinkResourceId("/subscriptions/6f53185c-ea09-4fc3-9075-318dec805303/resourceGroups/apiTest-ddat4p/providers/Microsoft.KeyVault/vaults/kvmo3ej9ih")
 *             .requestMessage("request message")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .sharedPrivateLinkResourceName("monitoringh22eed")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:SharedPrivateLinkResource monitoringh22eed /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}
 * ```
 */
public class SharedPrivateLinkResource internal constructor(
    override val javaResource: com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource,
) : KotlinCustomResource(javaResource, SharedPrivateLinkResourceMapper) {
    /**
     * The DNS zone to be included in the DNS name of the shared private link. Value is service-specific.
     */
    public val dnsZone: Output<String>?
        get() = javaResource.dnsZone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The group id from the provider of resource the shared private link resource is for.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource id of the resource the shared private link resource is for.
     */
    public val privateLinkResourceId: Output<String>
        get() = javaResource.privateLinkResourceId().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The request message for requesting approval of the shared private link resource.
     */
    public val requestMessage: Output<String>
        get() = javaResource.requestMessage().applyValue({ args0 -> args0 })

    /**
     * Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SharedPrivateLinkResourceMapper : ResourceMapper<SharedPrivateLinkResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource::class == javaResource::class

    override fun map(javaResource: Resource): SharedPrivateLinkResource =
        SharedPrivateLinkResource(
            javaResource as
                com.pulumi.azurenative.databasewatcher.SharedPrivateLinkResource,
        )
}

/**
 * @see [SharedPrivateLinkResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SharedPrivateLinkResource].
 */
public suspend fun sharedPrivateLinkResource(
    name: String,
    block: suspend SharedPrivateLinkResourceResourceBuilder.() -> Unit,
): SharedPrivateLinkResource {
    val builder = SharedPrivateLinkResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SharedPrivateLinkResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sharedPrivateLinkResource(name: String): SharedPrivateLinkResource {
    val builder = SharedPrivateLinkResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
