@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of a Kusto offering.
 */
public enum class KustoOfferingType(
    public val javaValue: com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType> {
    /**
     * The Azure Data Explorer cluster Kusto offering.
     */
    Adx(com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType.Adx),

    /**
     * The free Azure Data Explorer cluster Kusto offering.
     */
    Free(com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType.Free),

    /**
     * The Fabric Real-Time Analytics Kusto offering.
     */
    Fabric(com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType.Fabric),
    ;

    override fun toJava(): com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.enums.KustoOfferingType):
            KustoOfferingType = KustoOfferingType.values().first { it.javaValue == javaType }
    }
}
