@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The target collection status.
 */
public enum class TargetCollectionStatus(
    public val javaValue: com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus> {
    /**
     * Denotes a target that is enabled.
     */
    Enabled(com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus.Enabled),

    /**
     * Denotes a target that is disabled.
     */
    Disabled(com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.enums.TargetCollectionStatus):
            TargetCollectionStatus = TargetCollectionStatus.values().first { it.javaValue == javaType }
    }
}
