@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.inputs

import com.pulumi.azurenative.databasewatcher.inputs.GetTargetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property targetName The target resource name.
 * @property watcherName The database watcher name.
 */
public data class GetTargetPlainArgs(
    public val resourceGroupName: String,
    public val targetName: String,
    public val watcherName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.inputs.GetTargetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.inputs.GetTargetPlainArgs =
        com.pulumi.azurenative.databasewatcher.inputs.GetTargetPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .targetName(targetName.let({ args0 -> args0 }))
            .watcherName(watcherName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTargetPlainArgs].
 */
@PulumiTagMarker
public class GetTargetPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var targetName: String? = null

    private var watcherName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("moupfdhyrdovlmqy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The target resource name.
     */
    @JvmName("oegvfnchmpwbxxci")
    public suspend fun targetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetName = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("xwvnfwvohxkyljjq")
    public suspend fun watcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.watcherName = mapped
    }

    internal fun build(): GetTargetPlainArgs = GetTargetPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        targetName = targetName ?: throw PulumiNullFieldException("targetName"),
        watcherName = watcherName ?: throw PulumiNullFieldException("watcherName"),
    )
}
