@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The vault specific details required if using SQL authentication to connect to a target.
 * @property akvResourceId The Azure ResourceId of the Key Vault instance storing database authentication secrets.
 * @property akvTargetPassword The path to the Key Vault secret storing the password for authentication to a target.
 * @property akvTargetUser The path to the Key Vault secret storing the login name (aka user name, aka account name) for authentication to a target.
 */
public data class VaultSecretResponse(
    public val akvResourceId: String? = null,
    public val akvTargetPassword: String? = null,
    public val akvTargetUser: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.outputs.VaultSecretResponse):
            VaultSecretResponse = VaultSecretResponse(
            akvResourceId = javaType.akvResourceId().map({ args0 -> args0 }).orElse(null),
            akvTargetPassword = javaType.akvTargetPassword().map({ args0 -> args0 }).orElse(null),
            akvTargetUser = javaType.akvTargetUser().map({ args0 -> args0 }).orElse(null),
        )
    }
}
