@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin

import com.pulumi.azurenative.databox.JobArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.JobDeliveryType
import com.pulumi.azurenative.databox.kotlin.enums.TransferType
import com.pulumi.azurenative.databox.kotlin.inputs.JobDeliveryInfoArgs
import com.pulumi.azurenative.databox.kotlin.inputs.JobDeliveryInfoArgsBuilder
import com.pulumi.azurenative.databox.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.databox.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.databox.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.databox.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Job Resource.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-09-01, 2023-03-01, 2023-12-01, 2024-02-01-preview, 2024-03-01-preview.
 * ## Example Usage
 * ### JobsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = "Commercial",
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = "DataBox",
 *         },
 *         TransferType = "ImportToAzure",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     "Commercial",
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String("DataBox"),
 * 			},
 * 			TransferType: pulumi.String("ImportToAzure"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("dataImportDetails", Map.of("accountDetails", Map.ofEntries(
 *                     Map.entry("dataAccountType", "StorageAccount"),
 *                     Map.entry("storageAccountId", "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                 ))),
 *                 Map.entry("jobDetailsType", "DataBox"),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "Commercial"),
 *                     Map.entry("city", "XXXX XXXX"),
 *                     Map.entry("companyName", "XXXX XXXX"),
 *                     Map.entry("country", "XX"),
 *                     Map.entry("postalCode", "00000"),
 *                     Map.entry("stateOrProvince", "XX"),
 *                     Map.entry("streetAddress1", "XXXX XXXX"),
 *                     Map.entry("streetAddress2", "XXXX XXXX")
 *                 ))
 *             ))
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(Map.of("name", "DataBox"))
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateDevicePassword
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         SharePassword = "<sharePassword>",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             DevicePassword = "<devicePassword>",
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = "Commercial",
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = "DataBox",
 *         },
 *         TransferType = "ImportToAzure",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							SharePassword:    "<sharePassword>",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				DevicePassword: "<devicePassword>",
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     "Commercial",
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String("DataBox"),
 * 			},
 * 			TransferType: pulumi.String("ImportToAzure"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("dataImportDetails", Map.of("accountDetails", Map.ofEntries(
 *                     Map.entry("dataAccountType", "StorageAccount"),
 *                     Map.entry("sharePassword", "<sharePassword>"),
 *                     Map.entry("storageAccountId", "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                 ))),
 *                 Map.entry("devicePassword", "<devicePassword>"),
 *                 Map.entry("jobDetailsType", "DataBox"),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "Commercial"),
 *                     Map.entry("city", "XXXX XXXX"),
 *                     Map.entry("companyName", "XXXX XXXX"),
 *                     Map.entry("country", "XX"),
 *                     Map.entry("postalCode", "00000"),
 *                     Map.entry("stateOrProvince", "XX"),
 *                     Map.entry("streetAddress1", "XXXX XXXX"),
 *                     Map.entry("streetAddress2", "XXXX XXXX")
 *                 ))
 *             ))
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(Map.of("name", "DataBox"))
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateDoubleEncryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataImportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataImportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             Preferences = new AzureNative.DataBox.Inputs.PreferencesArgs
 *             {
 *                 EncryptionPreferences = new AzureNative.DataBox.Inputs.EncryptionPreferencesArgs
 *                 {
 *                     DoubleEncryption = "Enabled",
 *                 },
 *             },
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = "Commercial",
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = "DataBox",
 *         },
 *         TransferType = "ImportToAzure",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataImportDetails: []databox.DataImportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				Preferences: databox.Preferences{
 * 					EncryptionPreferences: databox.EncryptionPreferences{
 * 						DoubleEncryption: "Enabled",
 * 					},
 * 				},
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     "Commercial",
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String("DataBox"),
 * 			},
 * 			TransferType: pulumi.String("ImportToAzure"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("dataImportDetails", Map.of("accountDetails", Map.ofEntries(
 *                     Map.entry("dataAccountType", "StorageAccount"),
 *                     Map.entry("storageAccountId", "/subscriptions/YourSubscriptionId/resourcegroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                 ))),
 *                 Map.entry("jobDetailsType", "DataBox"),
 *                 Map.entry("preferences", Map.of("encryptionPreferences", Map.of("doubleEncryption", "Enabled"))),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "Commercial"),
 *                     Map.entry("city", "XXXX XXXX"),
 *                     Map.entry("companyName", "XXXX XXXX"),
 *                     Map.entry("country", "XX"),
 *                     Map.entry("postalCode", "00000"),
 *                     Map.entry("stateOrProvince", "XX"),
 *                     Map.entry("streetAddress1", "XXXX XXXX"),
 *                     Map.entry("streetAddress2", "XXXX XXXX")
 *                 ))
 *             ))
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(Map.of("name", "DataBox"))
 *             .transferType("ImportToAzure")
 *             .build());
 *     }
 * }
 * ```
 * ### JobsCreateExport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.DataBox.Job("job", new()
 *     {
 *         Details = new AzureNative.DataBox.Inputs.DataBoxJobDetailsArgs
 *         {
 *             ContactDetails = new AzureNative.DataBox.Inputs.ContactDetailsArgs
 *             {
 *                 ContactName = "XXXX XXXX",
 *                 EmailList = new[]
 *                 {
 *                     "xxxx@xxxx.xxx",
 *                 },
 *                 Phone = "0000000000",
 *                 PhoneExtension = "",
 *             },
 *             DataExportDetails = new[]
 *             {
 *                 new AzureNative.DataBox.Inputs.DataExportDetailsArgs
 *                 {
 *                     AccountDetails = new AzureNative.DataBox.Inputs.StorageAccountDetailsArgs
 *                     {
 *                         DataAccountType = "StorageAccount",
 *                         StorageAccountId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 *                     },
 *                     TransferConfiguration = new AzureNative.DataBox.Inputs.TransferConfigurationArgs
 *                     {
 *                         TransferAllDetails = new AzureNative.DataBox.Inputs.TransferConfigurationTransferAllDetailsArgs
 *                         {
 *                             Include = new AzureNative.DataBox.Inputs.TransferAllDetailsArgs
 *                             {
 *                                 DataAccountType = "StorageAccount",
 *                                 TransferAllBlobs = true,
 *                                 TransferAllFiles = true,
 *                             },
 *                         },
 *                         TransferConfigurationType = "TransferAll",
 *                     },
 *                 },
 *             },
 *             JobDetailsType = "DataBox",
 *             ShippingAddress = new AzureNative.DataBox.Inputs.ShippingAddressArgs
 *             {
 *                 AddressType = "Commercial",
 *                 City = "XXXX XXXX",
 *                 CompanyName = "XXXX XXXX",
 *                 Country = "XX",
 *                 PostalCode = "00000",
 *                 StateOrProvince = "XX",
 *                 StreetAddress1 = "XXXX XXXX",
 *                 StreetAddress2 = "XXXX XXXX",
 *             },
 *         },
 *         JobName = "TestJobName1",
 *         Location = "westus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         Sku = new AzureNative.DataBox.Inputs.SkuArgs
 *         {
 *             Name = "DataBox",
 *         },
 *         TransferType = "ExportFromAzure",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databox/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databox.NewJob(ctx, "job", &databox.JobArgs{
 * 			Details: databox.DataBoxJobDetails{
 * 				ContactDetails: databox.ContactDetails{
 * 					ContactName: "XXXX XXXX",
 * 					EmailList: []string{
 * 						"xxxx@xxxx.xxx",
 * 					},
 * 					Phone:          "0000000000",
 * 					PhoneExtension: "",
 * 				},
 * 				DataExportDetails: []databox.DataExportDetails{
 * 					{
 * 						AccountDetails: {
 * 							DataAccountType:  "StorageAccount",
 * 							StorageAccountId: "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName",
 * 						},
 * 						TransferConfiguration: {
 * 							TransferAllDetails: {
 * 								Include: {
 * 									DataAccountType:  "StorageAccount",
 * 									TransferAllBlobs: true,
 * 									TransferAllFiles: true,
 * 								},
 * 							},
 * 							TransferConfigurationType: "TransferAll",
 * 						},
 * 					},
 * 				},
 * 				JobDetailsType: "DataBox",
 * 				ShippingAddress: databox.ShippingAddress{
 * 					AddressType:     "Commercial",
 * 					City:            "XXXX XXXX",
 * 					CompanyName:     "XXXX XXXX",
 * 					Country:         "XX",
 * 					PostalCode:      "00000",
 * 					StateOrProvince: "XX",
 * 					StreetAddress1:  "XXXX XXXX",
 * 					StreetAddress2:  "XXXX XXXX",
 * 				},
 * 			},
 * 			JobName:           pulumi.String("TestJobName1"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			Sku: &databox.SkuArgs{
 * 				Name: pulumi.String("DataBox"),
 * 			},
 * 			TransferType: pulumi.String("ExportFromAzure"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databox.Job;
 * import com.pulumi.azurenative.databox.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .details(Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("dataExportDetails", Map.ofEntries(
 *                     Map.entry("accountDetails", Map.ofEntries(
 *                         Map.entry("dataAccountType", "StorageAccount"),
 *                         Map.entry("storageAccountId", "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.Storage/storageAccounts/YourStorageAccountName")
 *                     )),
 *                     Map.entry("transferConfiguration", Map.ofEntries(
 *                         Map.entry("transferAllDetails", Map.of("include", Map.ofEntries(
 *                             Map.entry("dataAccountType", "StorageAccount"),
 *                             Map.entry("transferAllBlobs", true),
 *                             Map.entry("transferAllFiles", true)
 *                         ))),
 *                         Map.entry("transferConfigurationType", "TransferAll")
 *                     ))
 *                 )),
 *                 Map.entry("jobDetailsType", "DataBox"),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "Commercial"),
 *                     Map.entry("city", "XXXX XXXX"),
 *                     Map.entry("companyName", "XXXX XXXX"),
 *                     Map.entry("country", "XX"),
 *                     Map.entry("postalCode", "00000"),
 *                     Map.entry("stateOrProvince", "XX"),
 *                     Map.entry("streetAddress1", "XXXX XXXX"),
 *                     Map.entry("streetAddress2", "XXXX XXXX")
 *                 ))
 *             ))
 *             .jobName("TestJobName1")
 *             .location("westus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .sku(Map.of("name", "DataBox"))
 *             .transferType("ExportFromAzure")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databox:Job TestJobName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}
 * ```
 * @property deliveryInfo Delivery Info of Job.
 * @property deliveryType Delivery type of Job.
 * @property details Details of a job run. This field will only be sent for expand details filter.
 * @property identity Msi identity of the resource
 * @property jobName The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property location The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
 * @property resourceGroupName The Resource Group Name
 * @property sku The sku type.
 * @property tags The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
 * @property transferType Type of the data transfer.
 */
public data class JobArgs(
    public val deliveryInfo: Output<JobDeliveryInfoArgs>? = null,
    public val deliveryType: Output<Either<String, JobDeliveryType>>? = null,
    public val details: Output<Any>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val jobName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transferType: Output<Either<String, TransferType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.JobArgs =
        com.pulumi.azurenative.databox.JobArgs.builder()
            .deliveryInfo(deliveryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deliveryType(
                deliveryType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .details(details?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transferType(
                transferType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var deliveryInfo: Output<JobDeliveryInfoArgs>? = null

    private var deliveryType: Output<Either<String, JobDeliveryType>>? = null

    private var details: Output<Any>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var jobName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transferType: Output<Either<String, TransferType>>? = null

    /**
     * @param value Delivery Info of Job.
     */
    @JvmName("cpgjjgvfnphhened")
    public suspend fun deliveryInfo(`value`: Output<JobDeliveryInfoArgs>) {
        this.deliveryInfo = value
    }

    /**
     * @param value Delivery type of Job.
     */
    @JvmName("owfbmwojskhxqhrk")
    public suspend fun deliveryType(`value`: Output<Either<String, JobDeliveryType>>) {
        this.deliveryType = value
    }

    /**
     * @param value Details of a job run. This field will only be sent for expand details filter.
     */
    @JvmName("tgeyfyyvgslkxajv")
    public suspend fun details(`value`: Output<Any>) {
        this.details = value
    }

    /**
     * @param value Msi identity of the resource
     */
    @JvmName("safxcskrodyihily")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("gkihjvlctdajyclo")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
     */
    @JvmName("nwogdkchswancmid")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("qasgjecnjscypmfp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku type.
     */
    @JvmName("qjwoapvwrupqqxxp")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
     */
    @JvmName("ygcisxvtbilpmqiw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of the data transfer.
     */
    @JvmName("lyyqspynhhygostc")
    public suspend fun transferType(`value`: Output<Either<String, TransferType>>) {
        this.transferType = value
    }

    /**
     * @param value Delivery Info of Job.
     */
    @JvmName("ybrckkgctbntnvoy")
    public suspend fun deliveryInfo(`value`: JobDeliveryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryInfo = mapped
    }

    /**
     * @param argument Delivery Info of Job.
     */
    @JvmName("rlhbjagwdhqqehbb")
    public suspend fun deliveryInfo(argument: suspend JobDeliveryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = JobDeliveryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryInfo = mapped
    }

    /**
     * @param value Delivery type of Job.
     */
    @JvmName("mjmfmojjppgreydu")
    public suspend fun deliveryType(`value`: Either<String, JobDeliveryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryType = mapped
    }

    /**
     * @param value Delivery type of Job.
     */
    @JvmName("iojovqywmaatemvl")
    public fun deliveryType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobDeliveryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryType = mapped
    }

    /**
     * @param value Delivery type of Job.
     */
    @JvmName("ejgfwwrvwlchkqom")
    public fun deliveryType(`value`: JobDeliveryType) {
        val toBeMapped = Either.ofRight<String, JobDeliveryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryType = mapped
    }

    /**
     * @param value Details of a job run. This field will only be sent for expand details filter.
     */
    @JvmName("lyxepqoercjdhwka")
    public suspend fun details(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param value Msi identity of the resource
     */
    @JvmName("tdcwodlyskldaeqt")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Msi identity of the resource
     */
    @JvmName("googbwnmwrqnsnty")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("vjgeyluhuvebmipf")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
     */
    @JvmName("polgguxvurgcdmwe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("wkrthurrkrhfmlol")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku type.
     */
    @JvmName("douysliauhsixpnf")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku type.
     */
    @JvmName("fiwhaqodovkwxdgk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
     */
    @JvmName("hxhrftshwxbkkphh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
     */
    @JvmName("efukqbxltlgyxfvc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of the data transfer.
     */
    @JvmName("qxdxnhwnqyvvwjou")
    public suspend fun transferType(`value`: Either<String, TransferType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferType = mapped
    }

    /**
     * @param value Type of the data transfer.
     */
    @JvmName("toqimlmuoydqtift")
    public fun transferType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransferType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferType = mapped
    }

    /**
     * @param value Type of the data transfer.
     */
    @JvmName("jabkenmwuqyogvxf")
    public fun transferType(`value`: TransferType) {
        val toBeMapped = Either.ofRight<String, TransferType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferType = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        deliveryInfo = deliveryInfo,
        deliveryType = deliveryType,
        details = details,
        identity = identity,
        jobName = jobName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        transferType = transferType,
    )
}
