@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of address.
 */
public enum class AddressType(
    public val javaValue: com.pulumi.azurenative.databox.enums.AddressType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.AddressType> {
    /**
     * Address type not known.
     */
    None(com.pulumi.azurenative.databox.enums.AddressType.None),

    /**
     * Residential Address.
     */
    Residential(com.pulumi.azurenative.databox.enums.AddressType.Residential),

    /**
     * Commercial Address.
     */
    Commercial(com.pulumi.azurenative.databox.enums.AddressType.Commercial),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.AddressType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.AddressType): AddressType =
            AddressType.values().first { it.javaValue == javaType }
    }
}
