@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ImportDiskDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Import disk details
 * @property bitLockerKey BitLocker key used to encrypt the disk.
 * @property manifestFile The relative path of the manifest file on the disk.
 * @property manifestHash The Base16-encoded MD5 hash of the manifest file on the disk.
 */
public data class ImportDiskDetailsArgs(
    public val bitLockerKey: Output<String>,
    public val manifestFile: Output<String>,
    public val manifestHash: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ImportDiskDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ImportDiskDetailsArgs =
        com.pulumi.azurenative.databox.inputs.ImportDiskDetailsArgs.builder()
            .bitLockerKey(bitLockerKey.applyValue({ args0 -> args0 }))
            .manifestFile(manifestFile.applyValue({ args0 -> args0 }))
            .manifestHash(manifestHash.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImportDiskDetailsArgs].
 */
@PulumiTagMarker
public class ImportDiskDetailsArgsBuilder internal constructor() {
    private var bitLockerKey: Output<String>? = null

    private var manifestFile: Output<String>? = null

    private var manifestHash: Output<String>? = null

    /**
     * @param value BitLocker key used to encrypt the disk.
     */
    @JvmName("oasmvvuhwwanjjng")
    public suspend fun bitLockerKey(`value`: Output<String>) {
        this.bitLockerKey = value
    }

    /**
     * @param value The relative path of the manifest file on the disk.
     */
    @JvmName("thcfttbvyhnpdfmx")
    public suspend fun manifestFile(`value`: Output<String>) {
        this.manifestFile = value
    }

    /**
     * @param value The Base16-encoded MD5 hash of the manifest file on the disk.
     */
    @JvmName("isxwaurlrjfitypg")
    public suspend fun manifestHash(`value`: Output<String>) {
        this.manifestHash = value
    }

    /**
     * @param value BitLocker key used to encrypt the disk.
     */
    @JvmName("evnuwhfjivaogrny")
    public suspend fun bitLockerKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bitLockerKey = mapped
    }

    /**
     * @param value The relative path of the manifest file on the disk.
     */
    @JvmName("fvkxqboraltxhnko")
    public suspend fun manifestFile(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestFile = mapped
    }

    /**
     * @param value The Base16-encoded MD5 hash of the manifest file on the disk.
     */
    @JvmName("agugwrixvdqxbrlc")
    public suspend fun manifestHash(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestHash = mapped
    }

    internal fun build(): ImportDiskDetailsArgs = ImportDiskDetailsArgs(
        bitLockerKey = bitLockerKey ?: throw PulumiNullFieldException("bitLockerKey"),
        manifestFile = manifestFile ?: throw PulumiNullFieldException("manifestFile"),
        manifestHash = manifestHash ?: throw PulumiNullFieldException("manifestHash"),
    )
}
