@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ListJobCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property resourceGroupName The Resource Group Name
 */
public data class ListJobCredentialsPlainArgs(
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ListJobCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ListJobCredentialsPlainArgs =
        com.pulumi.azurenative.databox.inputs.ListJobCredentialsPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListJobCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListJobCredentialsPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the job Resource within the specified resource group. job names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("lnvunciwffepgwck")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("jdfcexttqfhnclmb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListJobCredentialsPlainArgs = ListJobCredentialsPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
