@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ResourceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Msi identity details of the resource
 * @property type Identity type
 * @property userAssignedIdentities User Assigned Identities
 */
public data class ResourceIdentityArgs(
    public val type: Output<String>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.databox.inputs.ResourceIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Identity type
     */
    @JvmName("kilnjwrfccpybwmx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User Assigned Identities
     */
    @JvmName("awoqdkbnfmrktbru")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("egmldghbwgfiieci")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values User Assigned Identities
     */
    @JvmName("patbcmemwdabgxbo")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Identity type
     */
    @JvmName("jttqpxolmutpgnhd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User Assigned Identities
     */
    @JvmName("jbqtpphjeisqvgnf")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values User Assigned Identities
     */
    @JvmName("gxmkaljnhlelevio")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
