@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.StorageAccountDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details for the storage account.
 * @property dataAccountType Account Type of the data to be transferred.
 * Expected value is 'StorageAccount'.
 * @property sharePassword Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
 * @property storageAccountId Storage Account Resource Id.
 */
public data class StorageAccountDetailsArgs(
    public val dataAccountType: Output<String>,
    public val sharePassword: Output<String>? = null,
    public val storageAccountId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.StorageAccountDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.StorageAccountDetailsArgs =
        com.pulumi.azurenative.databox.inputs.StorageAccountDetailsArgs.builder()
            .dataAccountType(dataAccountType.applyValue({ args0 -> args0 }))
            .sharePassword(sharePassword?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountDetailsArgs].
 */
@PulumiTagMarker
public class StorageAccountDetailsArgsBuilder internal constructor() {
    private var dataAccountType: Output<String>? = null

    private var sharePassword: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    /**
     * @param value Account Type of the data to be transferred.
     * Expected value is 'StorageAccount'.
     */
    @JvmName("rlxwuxpoydwpxgci")
    public suspend fun dataAccountType(`value`: Output<String>) {
        this.dataAccountType = value
    }

    /**
     * @param value Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("kfxjwmfkhmhmgswa")
    public suspend fun sharePassword(`value`: Output<String>) {
        this.sharePassword = value
    }

    /**
     * @param value Storage Account Resource Id.
     */
    @JvmName("apwgjbhaxrshoeqp")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Account Type of the data to be transferred.
     * Expected value is 'StorageAccount'.
     */
    @JvmName("untmkddqugkdxecv")
    public suspend fun dataAccountType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccountType = mapped
    }

    /**
     * @param value Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("tpbkrrcaqsoxotjb")
    public suspend fun sharePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharePassword = mapped
    }

    /**
     * @param value Storage Account Resource Id.
     */
    @JvmName("nvwddlanthvtmpnr")
    public suspend fun storageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    internal fun build(): StorageAccountDetailsArgs = StorageAccountDetailsArgs(
        dataAccountType = dataAccountType ?: throw PulumiNullFieldException("dataAccountType"),
        sharePassword = sharePassword,
        storageAccountId = storageAccountId ?: throw PulumiNullFieldException("storageAccountId"),
    )
}
