@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * This class represents additional info which Resource Providers pass when an error occurs.
 * @property info Additional information of the type of error.
 * @property type Type of error (e.g. CustomerIntervention, PolicyViolation, SecurityViolation).
 */
public data class AdditionalErrorInfoResponse(
    public val info: Any? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.AdditionalErrorInfoResponse):
            AdditionalErrorInfoResponse = AdditionalErrorInfoResponse(
            info = javaType.info().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
