@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filter details to transfer Azure files
 * @property filePathList List of full path of the files to be transferred.
 * @property filePrefixList Prefix list of the Azure files to be transferred.
 * @property fileShareList List of file shares to be transferred.
 */
public data class AzureFileFilterDetailsResponse(
    public val filePathList: List<String>? = null,
    public val filePrefixList: List<String>? = null,
    public val fileShareList: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.AzureFileFilterDetailsResponse):
            AzureFileFilterDetailsResponse = AzureFileFilterDetailsResponse(
            filePathList = javaType.filePathList().map({ args0 -> args0 }),
            filePrefixList = javaType.filePrefixList().map({ args0 -> args0 }),
            fileShareList = javaType.fileShareList().map({ args0 -> args0 }),
        )
    }
}
