@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Details of the data to be used for importing data to azure.
 * @property accountDetails Account details of the data to be transferred
 * @property logCollectionLevel Level of the logs to be collected.
 */
public data class DataImportDetailsResponse(
    public val accountDetails: Either<ManagedDiskDetailsResponse, StorageAccountDetailsResponse>,
    public val logCollectionLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataImportDetailsResponse):
            DataImportDetailsResponse = DataImportDetailsResponse(
            accountDetails = javaType.accountDetails().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.ManagedDiskDetailsResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.StorageAccountDetailsResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            logCollectionLevel = javaType.logCollectionLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
