@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Datacenter address for given storage location.
 * @property additionalShippingInformation Special instruction for shipping
 * @property addressType Address type
 * @property city City name
 * @property company Company name
 * @property contactPersonName Contact person name
 * @property country name of the country
 * @property dataCenterAzureLocation Azure Location where the Data Center serves primarily.
 * @property datacenterAddressType Data center address type
 * Expected value is 'DatacenterAddressLocation'.
 * @property phone Phone number
 * @property phoneExtension Phone extension
 * @property state name of the state
 * @property street1 Street address line 1
 * @property street2 Street address line 2
 * @property street3 Street address line 3
 * @property supportedCarriersForReturnShipment List of supported carriers for return shipment.
 * @property zip Zip code
 */
public data class DatacenterAddressLocationResponseResponse(
    public val additionalShippingInformation: String,
    public val addressType: String,
    public val city: String,
    public val company: String,
    public val contactPersonName: String,
    public val country: String,
    public val dataCenterAzureLocation: String,
    public val datacenterAddressType: String,
    public val phone: String,
    public val phoneExtension: String,
    public val state: String,
    public val street1: String,
    public val street2: String,
    public val street3: String,
    public val supportedCarriersForReturnShipment: List<String>,
    public val zip: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DatacenterAddressLocationResponseResponse):
            DatacenterAddressLocationResponseResponse = DatacenterAddressLocationResponseResponse(
            additionalShippingInformation = javaType.additionalShippingInformation(),
            addressType = javaType.addressType(),
            city = javaType.city(),
            company = javaType.company(),
            contactPersonName = javaType.contactPersonName(),
            country = javaType.country(),
            dataCenterAzureLocation = javaType.dataCenterAzureLocation(),
            datacenterAddressType = javaType.datacenterAddressType(),
            phone = javaType.phone(),
            phoneExtension = javaType.phoneExtension(),
            state = javaType.state(),
            street1 = javaType.street1(),
            street2 = javaType.street2(),
            street3 = javaType.street3(),
            supportedCarriersForReturnShipment = javaType.supportedCarriersForReturnShipment().map({ args0 ->
                args0
            }),
            zip = javaType.zip(),
        )
    }
}
