@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Last Mitigation Action Performed On Job
 * @property actionDateTimeInUtc Action performed date time
 * @property customerResolution Resolution code provided by customer
 * @property isPerformedByCustomer Action performed by customer,
 * possibility is that mitigation might happen by customer or service or by ops
 */
public data class LastMitigationActionOnJobResponse(
    public val actionDateTimeInUtc: String? = null,
    public val customerResolution: String? = null,
    public val isPerformedByCustomer: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.LastMitigationActionOnJobResponse):
            LastMitigationActionOnJobResponse = LastMitigationActionOnJobResponse(
            actionDateTimeInUtc = javaType.actionDateTimeInUtc().map({ args0 -> args0 }).orElse(null),
            customerResolution = javaType.customerResolution().map({ args0 -> args0 }).orElse(null),
            isPerformedByCustomer = javaType.isPerformedByCustomer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
