@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Preferences related to the order
 * @property encryptionPreferences Preferences related to the Encryption.
 * @property preferredDataCenterRegion Preferred data center region.
 * @property reverseTransportPreferences Optional Preferences related to the reverse shipment logistics of the sku.
 * @property storageAccountAccessTierPreferences Preferences related to the Access Tier of storage accounts.
 * @property transportPreferences Preferences related to the shipment logistics of the sku.
 */
public data class PreferencesResponse(
    public val encryptionPreferences: EncryptionPreferencesResponse? = null,
    public val preferredDataCenterRegion: List<String>? = null,
    public val reverseTransportPreferences: TransportPreferencesResponse? = null,
    public val storageAccountAccessTierPreferences: List<String>? = null,
    public val transportPreferences: TransportPreferencesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.PreferencesResponse):
            PreferencesResponse = PreferencesResponse(
            encryptionPreferences = javaType.encryptionPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.EncryptionPreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preferredDataCenterRegion = javaType.preferredDataCenterRegion().map({ args0 -> args0 }),
            reverseTransportPreferences = javaType.reverseTransportPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.TransportPreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountAccessTierPreferences = javaType.storageAccountAccessTierPreferences().map({ args0 ->
                args0
            }),
            transportPreferences = javaType.transportPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.TransportPreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
