@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details for the storage account.
 * @property dataAccountType Account Type of the data to be transferred.
 * Expected value is 'StorageAccount'.
 * @property storageAccountId Storage Account Resource Id.
 */
public data class StorageAccountDetailsResponse(
    public val dataAccountType: String,
    public val storageAccountId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.StorageAccountDetailsResponse):
            StorageAccountDetailsResponse = StorageAccountDetailsResponse(
            dataAccountType = javaType.dataAccountType(),
            storageAccountId = javaType.storageAccountId(),
        )
    }
}
