@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for defining the transfer of data.
 * @property transferAllDetails Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
 * @property transferConfigurationType Type of the configuration for transfer.
 * @property transferFilterDetails Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
 */
public data class TransferConfigurationResponse(
    public val transferAllDetails: TransferConfigurationResponseTransferAllDetails? = null,
    public val transferConfigurationType: String,
    public val transferFilterDetails: TransferConfigurationResponseTransferFilterDetails? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.TransferConfigurationResponse):
            TransferConfigurationResponse = TransferConfigurationResponse(
            transferAllDetails = javaType.transferAllDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.TransferConfigurationResponseTransferAllDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            transferConfigurationType = javaType.transferConfigurationType(),
            transferFilterDetails = javaType.transferFilterDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.TransferConfigurationResponseTransferFilterDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
