@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.FileEventTriggerArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.FileSourceInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.FileSourceInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RoleSinkInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.RoleSinkInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Trigger details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### TriggerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileEventTrigger = new AzureNative.DataBoxEdge.FileEventTrigger("fileEventTrigger", new()
 *     {
 *         CustomContextTag = "CustomContextTags-1235346475",
 *         DeviceName = "testedgedevice",
 *         Kind = "FileEvent",
 *         Name = "trigger1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         SinkInfo = new AzureNative.DataBoxEdge.Inputs.RoleSinkInfoArgs
 *         {
 *             RoleId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1",
 *         },
 *         SourceInfo = new AzureNative.DataBoxEdge.Inputs.FileSourceInfoArgs
 *         {
 *             ShareId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewFileEventTrigger(ctx, "fileEventTrigger", &databoxedge.FileEventTriggerArgs{
 * 			CustomContextTag:  pulumi.String("CustomContextTags-1235346475"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Kind:              pulumi.String("FileEvent"),
 * 			Name:              pulumi.String("trigger1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			SinkInfo: &databoxedge.RoleSinkInfoArgs{
 * 				RoleId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1"),
 * 			},
 * 			SourceInfo: &databoxedge.FileSourceInfoArgs{
 * 				ShareId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.FileEventTrigger;
 * import com.pulumi.azurenative.databoxedge.FileEventTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileEventTrigger = new FileEventTrigger("fileEventTrigger", FileEventTriggerArgs.builder()
 *             .customContextTag("CustomContextTags-1235346475")
 *             .deviceName("testedgedevice")
 *             .kind("FileEvent")
 *             .name("trigger1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sinkInfo(Map.of("roleId", "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1"))
 *             .sourceInfo(Map.of("shareId", "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:FileEventTrigger trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/triggers/{name}
 * ```
 * @property customContextTag A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
 * @property deviceName Creates or updates a trigger
 * @property kind Trigger Kind.
 * Expected value is 'FileEvent'.
 * @property name The trigger name.
 * @property resourceGroupName The resource group name.
 * @property sinkInfo Role sink info.
 * @property sourceInfo File event source details.
 */
public data class FileEventTriggerArgs(
    public val customContextTag: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sinkInfo: Output<RoleSinkInfoArgs>? = null,
    public val sourceInfo: Output<FileSourceInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.FileEventTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.FileEventTriggerArgs =
        com.pulumi.azurenative.databoxedge.FileEventTriggerArgs.builder()
            .customContextTag(customContextTag?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sinkInfo(sinkInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceInfo(sourceInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FileEventTriggerArgs].
 */
@PulumiTagMarker
public class FileEventTriggerArgsBuilder internal constructor() {
    private var customContextTag: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sinkInfo: Output<RoleSinkInfoArgs>? = null

    private var sourceInfo: Output<FileSourceInfoArgs>? = null

    /**
     * @param value A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    @JvmName("rengrvauirdbrryo")
    public suspend fun customContextTag(`value`: Output<String>) {
        this.customContextTag = value
    }

    /**
     * @param value Creates or updates a trigger
     */
    @JvmName("plhyrujshnaqbqis")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Trigger Kind.
     * Expected value is 'FileEvent'.
     */
    @JvmName("yiolhmpelhjjwqgl")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("levrtvjtbddwylmv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lvnklkqtduwybcjs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role sink info.
     */
    @JvmName("yhomglvqadjaacuy")
    public suspend fun sinkInfo(`value`: Output<RoleSinkInfoArgs>) {
        this.sinkInfo = value
    }

    /**
     * @param value File event source details.
     */
    @JvmName("ioogrbygxqawfrrv")
    public suspend fun sourceInfo(`value`: Output<FileSourceInfoArgs>) {
        this.sourceInfo = value
    }

    /**
     * @param value A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    @JvmName("iknoewihkcnpywns")
    public suspend fun customContextTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContextTag = mapped
    }

    /**
     * @param value Creates or updates a trigger
     */
    @JvmName("jinafjyyfwekockx")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Trigger Kind.
     * Expected value is 'FileEvent'.
     */
    @JvmName("ohpnichwkgirbcmu")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("qkhqmmopfdclqixd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ctmjrnnpxnmgvulo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role sink info.
     */
    @JvmName("rgnboyudaixlaywt")
    public suspend fun sinkInfo(`value`: RoleSinkInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkInfo = mapped
    }

    /**
     * @param argument Role sink info.
     */
    @JvmName("pkwjqnuhbfedcqry")
    public suspend fun sinkInfo(argument: suspend RoleSinkInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RoleSinkInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sinkInfo = mapped
    }

    /**
     * @param value File event source details.
     */
    @JvmName("kiyvepvdkatvgnbx")
    public suspend fun sourceInfo(`value`: FileSourceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceInfo = mapped
    }

    /**
     * @param argument File event source details.
     */
    @JvmName("cxubudlhucipekng")
    public suspend fun sourceInfo(argument: suspend FileSourceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = FileSourceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceInfo = mapped
    }

    internal fun build(): FileEventTriggerArgs = FileEventTriggerArgs(
        customContextTag = customContextTag,
        deviceName = deviceName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        sinkInfo = sinkInfo,
        sourceInfo = sourceInfo,
    )
}
