@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin as ioTDeviceInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IoTAddon].
 */
@PulumiTagMarker
public class IoTAddonResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IoTAddonArgs = IoTAddonArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IoTAddonArgsBuilder.() -> Unit) {
        val builder = IoTAddonArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IoTAddon {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.IoTAddon(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IoTAddon(builtJavaResource)
    }
}

/**
 * IoT Addon.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### PutAddOns
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTAddon = new AzureNative.DataBoxEdge.IoTAddon("ioTAddon", new()
 *     {
 *         AddonName = "arcName",
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleName = "KubernetesRole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewIoTAddon(ctx, "ioTAddon", &databoxedge.IoTAddonArgs{
 * 			AddonName:         pulumi.String("arcName"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			RoleName:          pulumi.String("KubernetesRole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.IoTAddon;
 * import com.pulumi.azurenative.databoxedge.IoTAddonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTAddon = new IoTAddon("ioTAddon", IoTAddonArgs.builder()
 *             .addonName("arcName")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleName("KubernetesRole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:IoTAddon arcName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/addons/{addonName}
 * ```
 */
public class IoTAddon internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.IoTAddon,
) : KotlinCustomResource(javaResource, IoTAddonMapper) {
    /**
     * Host OS supported by the IoT addon.
     */
    public val hostPlatform: Output<String>
        get() = javaResource.hostPlatform().applyValue({ args0 -> args0 })

    /**
     * Platform where the runtime is hosted.
     */
    public val hostPlatformType: Output<String>
        get() = javaResource.hostPlatformType().applyValue({ args0 -> args0 })

    /**
     * IoT device metadata to which appliance needs to be connected.
     */
    public val ioTDeviceDetails: Output<IoTDeviceInfoResponse>
        get() = javaResource.ioTDeviceDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                ioTDeviceInfoResponseToKotlin(args0)
            })
        })

    /**
     * IoT edge device to which the IoT Addon needs to be configured.
     */
    public val ioTEdgeDeviceDetails: Output<IoTDeviceInfoResponse>
        get() = javaResource.ioTEdgeDeviceDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                ioTDeviceInfoResponseToKotlin(args0)
            })
        })

    /**
     * Addon type.
     * Expected value is 'IotEdge'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Addon Provisioning State
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Addon
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of IoT running on the appliance.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object IoTAddonMapper : ResourceMapper<IoTAddon> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.IoTAddon::class == javaResource::class

    override fun map(javaResource: Resource): IoTAddon = IoTAddon(
        javaResource as
            com.pulumi.azurenative.databoxedge.IoTAddon,
    )
}

/**
 * @see [IoTAddon].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IoTAddon].
 */
public suspend fun ioTAddon(name: String, block: suspend IoTAddonResourceBuilder.() -> Unit):
    IoTAddon {
    val builder = IoTAddonResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IoTAddon].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ioTAddon(name: String): IoTAddon {
    val builder = IoTAddonResourceBuilder()
    builder.name(name)
    return builder.build()
}
