@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.ComputeResourceResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTEdgeAgentInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ComputeResourceResponse.Companion.toKotlin as computeResourceResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin as ioTDeviceInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTEdgeAgentInfoResponse.Companion.toKotlin as ioTEdgeAgentInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse.Companion.toKotlin as mountPointMapResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IoTRole].
 */
@PulumiTagMarker
public class IoTRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IoTRoleArgs = IoTRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IoTRoleArgsBuilder.() -> Unit) {
        val builder = IoTRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IoTRole {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.IoTRole(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IoTRole(builtJavaResource)
    }
}

/**
 * Compute role.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ioTRole = new AzureNative.DataBoxEdge.IoTRole("ioTRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         HostPlatform = "Linux",
 *         IoTDeviceDetails = new AzureNative.DataBoxEdge.Inputs.IoTDeviceInfoArgs
 *         {
 *             Authentication = new AzureNative.DataBoxEdge.Inputs.AuthenticationArgs
 *             {
 *                 SymmetricKey = new AzureNative.DataBoxEdge.Inputs.SymmetricKeyArgs
 *                 {
 *                     ConnectionString = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *                     {
 *                         EncryptionAlgorithm = "AES256",
 *                         EncryptionCertThumbprint = "348586569999244",
 *                         Value = "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>",
 *                     },
 *                 },
 *             },
 *             DeviceId = "iotdevice",
 *             IoTHostHub = "iothub.azure-devices.net",
 *         },
 *         IoTEdgeDeviceDetails = new AzureNative.DataBoxEdge.Inputs.IoTDeviceInfoArgs
 *         {
 *             Authentication = new AzureNative.DataBoxEdge.Inputs.AuthenticationArgs
 *             {
 *                 SymmetricKey = new AzureNative.DataBoxEdge.Inputs.SymmetricKeyArgs
 *                 {
 *                     ConnectionString = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *                     {
 *                         EncryptionAlgorithm = "AES256",
 *                         EncryptionCertThumbprint = "1245475856069999244",
 *                         Value = "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>",
 *                     },
 *                 },
 *             },
 *             DeviceId = "iotEdge",
 *             IoTHostHub = "iothub.azure-devices.net",
 *         },
 *         Kind = "IOT",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleStatus = "Enabled",
 *         ShareMappings = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := databoxedge.NewIoTRole(ctx, "ioTRole", &databoxedge.IoTRoleArgs{
 * DeviceName: pulumi.String("testedgedevice"),
 * HostPlatform: pulumi.String("Linux"),
 * IoTDeviceDetails: databoxedge.IoTDeviceInfoResponse{
 * Authentication: interface{}{
 * SymmetricKey: interface{}{
 * ConnectionString: &databoxedge.AsymmetricEncryptedSecretArgs{
 * EncryptionAlgorithm: pulumi.String("AES256"),
 * EncryptionCertThumbprint: pulumi.String("348586569999244"),
 * Value: pulumi.String("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>"),
 * },
 * },
 * },
 * DeviceId: pulumi.String("iotdevice"),
 * IoTHostHub: pulumi.String("iothub.azure-devices.net"),
 * },
 * IoTEdgeDeviceDetails: databoxedge.IoTDeviceInfoResponse{
 * Authentication: interface{}{
 * SymmetricKey: interface{}{
 * ConnectionString: &databoxedge.AsymmetricEncryptedSecretArgs{
 * EncryptionAlgorithm: pulumi.String("AES256"),
 * EncryptionCertThumbprint: pulumi.String("1245475856069999244"),
 * Value: pulumi.String("Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>"),
 * },
 * },
 * },
 * DeviceId: pulumi.String("iotEdge"),
 * IoTHostHub: pulumi.String("iothub.azure-devices.net"),
 * },
 * Kind: pulumi.String("IOT"),
 * Name: pulumi.String("IoTRole1"),
 * ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * RoleStatus: pulumi.String("Enabled"),
 * ShareMappings: databoxedge.MountPointMapArray{
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.IoTRole;
 * import com.pulumi.azurenative.databoxedge.IoTRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ioTRole = new IoTRole("ioTRole", IoTRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .hostPlatform("Linux")
 *             .ioTDeviceDetails(Map.ofEntries(
 *                 Map.entry("authentication", Map.of("symmetricKey", Map.of("connectionString", Map.ofEntries(
 *                     Map.entry("encryptionAlgorithm", "AES256"),
 *                     Map.entry("encryptionCertThumbprint", "348586569999244"),
 *                     Map.entry("value", "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotDevice;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>")
 *                 )))),
 *                 Map.entry("deviceId", "iotdevice"),
 *                 Map.entry("ioTHostHub", "iothub.azure-devices.net")
 *             ))
 *             .ioTEdgeDeviceDetails(Map.ofEntries(
 *                 Map.entry("authentication", Map.of("symmetricKey", Map.of("connectionString", Map.ofEntries(
 *                     Map.entry("encryptionAlgorithm", "AES256"),
 *                     Map.entry("encryptionCertThumbprint", "1245475856069999244"),
 *                     Map.entry("value", "Encrypted<<HostName=iothub.azure-devices.net;DeviceId=iotEdge;SharedAccessKey=2C750FscEas3JmQ8Bnui5yQWZPyml0/UiRt1bQwd8=>>")
 *                 )))),
 *                 Map.entry("deviceId", "iotEdge"),
 *                 Map.entry("ioTHostHub", "iothub.azure-devices.net")
 *             ))
 *             .kind("IOT")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleStatus("Enabled")
 *             .shareMappings()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:IoTRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 */
public class IoTRole internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.IoTRole,
) : KotlinCustomResource(javaResource, IoTRoleMapper) {
    /**
     * Resource allocation
     */
    public val computeResource: Output<ComputeResourceResponse>?
        get() = javaResource.computeResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> computeResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Host OS supported by the IoT role.
     */
    public val hostPlatform: Output<String>
        get() = javaResource.hostPlatform().applyValue({ args0 -> args0 })

    /**
     * Platform where the Iot runtime is hosted.
     */
    public val hostPlatformType: Output<String>
        get() = javaResource.hostPlatformType().applyValue({ args0 -> args0 })

    /**
     * IoT device metadata to which data box edge device needs to be connected.
     */
    public val ioTDeviceDetails: Output<IoTDeviceInfoResponse>
        get() = javaResource.ioTDeviceDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                ioTDeviceInfoResponseToKotlin(args0)
            })
        })

    /**
     * Iot edge agent details to download the agent and bootstrap iot runtime.
     */
    public val ioTEdgeAgentInfo: Output<IoTEdgeAgentInfoResponse>?
        get() = javaResource.ioTEdgeAgentInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ioTEdgeAgentInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IoT edge device to which the IoT role needs to be configured.
     */
    public val ioTEdgeDeviceDetails: Output<IoTDeviceInfoResponse>
        get() = javaResource.ioTEdgeDeviceDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                ioTDeviceInfoResponseToKotlin(args0)
            })
        })

    /**
     * Role type.
     * Expected value is 'IOT'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Role status.
     */
    public val roleStatus: Output<String>
        get() = javaResource.roleStatus().applyValue({ args0 -> args0 })

    /**
     * Mount points of shares in role(s).
     */
    public val shareMappings: Output<List<MountPointMapResponse>>?
        get() = javaResource.shareMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        mountPointMapResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of Role
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IoTRoleMapper : ResourceMapper<IoTRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.IoTRole::class == javaResource::class

    override fun map(javaResource: Resource): IoTRole = IoTRole(
        javaResource as
            com.pulumi.azurenative.databoxedge.IoTRole,
    )
}

/**
 * @see [IoTRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IoTRole].
 */
public suspend fun ioTRole(name: String, block: suspend IoTRoleResourceBuilder.() -> Unit):
    IoTRole {
    val builder = IoTRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IoTRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ioTRole(name: String): IoTRole {
    val builder = IoTRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
