@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesClusterInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleResourcesResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesClusterInfoResponse.Companion.toKotlin as kubernetesClusterInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleResourcesResponse.Companion.toKotlin as kubernetesRoleResourcesResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KubernetesRole].
 */
@PulumiTagMarker
public class KubernetesRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesRoleArgs = KubernetesRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesRoleArgsBuilder.() -> Unit) {
        val builder = KubernetesRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KubernetesRole {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.KubernetesRole(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KubernetesRole(builtJavaResource)
    }
}

/**
 * The limited preview of Kubernetes Cluster Management from the Azure supports:
 * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
 * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
 *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
 * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
 *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
 *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
 *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubernetesRole = new AzureNative.DataBoxEdge.KubernetesRole("kubernetesRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewKubernetesRole(ctx, "kubernetesRole", &databoxedge.KubernetesRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.KubernetesRole;
 * import com.pulumi.azurenative.databoxedge.KubernetesRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubernetesRole = new KubernetesRole("kubernetesRole", KubernetesRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:KubernetesRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 */
public class KubernetesRole internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.KubernetesRole,
) : KotlinCustomResource(javaResource, KubernetesRoleMapper) {
    /**
     * Host OS supported by the Kubernetes role.
     */
    public val hostPlatform: Output<String>
        get() = javaResource.hostPlatform().applyValue({ args0 -> args0 })

    /**
     * Platform where the runtime is hosted.
     */
    public val hostPlatformType: Output<String>
        get() = javaResource.hostPlatformType().applyValue({ args0 -> args0 })

    /**
     * Role type.
     * Expected value is 'Kubernetes'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Kubernetes cluster configuration
     */
    public val kubernetesClusterInfo: Output<KubernetesClusterInfoResponse>
        get() = javaResource.kubernetesClusterInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                kubernetesClusterInfoResponseToKotlin(args0)
            })
        })

    /**
     * Kubernetes role resources
     */
    public val kubernetesRoleResources: Output<KubernetesRoleResourcesResponse>
        get() = javaResource.kubernetesRoleResources().applyValue({ args0 ->
            args0.let({ args0 ->
                kubernetesRoleResourcesResponseToKotlin(args0)
            })
        })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of Kubernetes deployment
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Role status.
     */
    public val roleStatus: Output<String>
        get() = javaResource.roleStatus().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Role
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KubernetesRoleMapper : ResourceMapper<KubernetesRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.KubernetesRole::class == javaResource::class

    override fun map(javaResource: Resource): KubernetesRole = KubernetesRole(
        javaResource as
            com.pulumi.azurenative.databoxedge.KubernetesRole,
    )
}

/**
 * @see [KubernetesRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KubernetesRole].
 */
public suspend fun kubernetesRole(
    name: String,
    block: suspend KubernetesRoleResourceBuilder.() -> Unit,
): KubernetesRole {
    val builder = KubernetesRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KubernetesRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetesRole(name: String): KubernetesRole {
    val builder = KubernetesRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
