@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.KubernetesRoleArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.PlatformType
import com.pulumi.azurenative.databoxedge.kotlin.enums.RoleStatus
import com.pulumi.azurenative.databoxedge.kotlin.inputs.KubernetesClusterInfoArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.KubernetesClusterInfoArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.KubernetesRoleResourcesArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.KubernetesRoleResourcesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The limited preview of Kubernetes Cluster Management from the Azure supports:
 * 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
 * 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure Portal.
 *  Azure Arc enables organizations to view, manage, and govern their on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
 * 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data.
 *  For more information, refer to the document here: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
 *  Or Demo: https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
 *  By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubernetesRole = new AzureNative.DataBoxEdge.KubernetesRole("kubernetesRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewKubernetesRole(ctx, "kubernetesRole", &databoxedge.KubernetesRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.KubernetesRole;
 * import com.pulumi.azurenative.databoxedge.KubernetesRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubernetesRole = new KubernetesRole("kubernetesRole", KubernetesRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:KubernetesRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 * @property deviceName The device name.
 * @property hostPlatform Host OS supported by the Kubernetes role.
 * @property kind Role type.
 * Expected value is 'Kubernetes'.
 * @property kubernetesClusterInfo Kubernetes cluster configuration
 * @property kubernetesRoleResources Kubernetes role resources
 * @property name The role name.
 * @property resourceGroupName The resource group name.
 * @property roleStatus Role status.
 */
public data class KubernetesRoleArgs(
    public val deviceName: Output<String>? = null,
    public val hostPlatform: Output<Either<String, PlatformType>>? = null,
    public val kind: Output<String>? = null,
    public val kubernetesClusterInfo: Output<KubernetesClusterInfoArgs>? = null,
    public val kubernetesRoleResources: Output<KubernetesRoleResourcesArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleStatus: Output<Either<String, RoleStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.KubernetesRoleArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.KubernetesRoleArgs =
        com.pulumi.azurenative.databoxedge.KubernetesRoleArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .hostPlatform(
                hostPlatform?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kubernetesClusterInfo(
                kubernetesClusterInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kubernetesRoleResources(
                kubernetesRoleResources?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleStatus(
                roleStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [KubernetesRoleArgs].
 */
@PulumiTagMarker
public class KubernetesRoleArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var hostPlatform: Output<Either<String, PlatformType>>? = null

    private var kind: Output<String>? = null

    private var kubernetesClusterInfo: Output<KubernetesClusterInfoArgs>? = null

    private var kubernetesRoleResources: Output<KubernetesRoleResourcesArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleStatus: Output<Either<String, RoleStatus>>? = null

    /**
     * @param value The device name.
     */
    @JvmName("mdfwnigxcocuyyhg")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Host OS supported by the Kubernetes role.
     */
    @JvmName("indyqxnhudaxobfi")
    public suspend fun hostPlatform(`value`: Output<Either<String, PlatformType>>) {
        this.hostPlatform = value
    }

    /**
     * @param value Role type.
     * Expected value is 'Kubernetes'.
     */
    @JvmName("arndtjjaqhudreyr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Kubernetes cluster configuration
     */
    @JvmName("udejraoghnlppegy")
    public suspend fun kubernetesClusterInfo(`value`: Output<KubernetesClusterInfoArgs>) {
        this.kubernetesClusterInfo = value
    }

    /**
     * @param value Kubernetes role resources
     */
    @JvmName("swnlgjqnnjaibswi")
    public suspend fun kubernetesRoleResources(`value`: Output<KubernetesRoleResourcesArgs>) {
        this.kubernetesRoleResources = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("woffcfgpmedynllq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("mosyyayqvfyciqqq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role status.
     */
    @JvmName("hewdmawehdnlxcvp")
    public suspend fun roleStatus(`value`: Output<Either<String, RoleStatus>>) {
        this.roleStatus = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("mhdlaqikpfhmbxcx")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Host OS supported by the Kubernetes role.
     */
    @JvmName("xfdruvnabdocfwqy")
    public suspend fun hostPlatform(`value`: Either<String, PlatformType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value Host OS supported by the Kubernetes role.
     */
    @JvmName("tpuyeqaddqrtymrp")
    public fun hostPlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value Host OS supported by the Kubernetes role.
     */
    @JvmName("opkeyiyiugxigoku")
    public fun hostPlatform(`value`: PlatformType) {
        val toBeMapped = Either.ofRight<String, PlatformType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPlatform = mapped
    }

    /**
     * @param value Role type.
     * Expected value is 'Kubernetes'.
     */
    @JvmName("orqmfxcgtkivxfuf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kubernetes cluster configuration
     */
    @JvmName("suqqltxqoagcyqbt")
    public suspend fun kubernetesClusterInfo(`value`: KubernetesClusterInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesClusterInfo = mapped
    }

    /**
     * @param argument Kubernetes cluster configuration
     */
    @JvmName("ecrjskruoqgfqcbm")
    public suspend
    fun kubernetesClusterInfo(argument: suspend KubernetesClusterInfoArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesClusterInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubernetesClusterInfo = mapped
    }

    /**
     * @param value Kubernetes role resources
     */
    @JvmName("tufrtqcivlruoctf")
    public suspend fun kubernetesRoleResources(`value`: KubernetesRoleResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesRoleResources = mapped
    }

    /**
     * @param argument Kubernetes role resources
     */
    @JvmName("jmmucywaumdflqwq")
    public suspend
    fun kubernetesRoleResources(argument: suspend KubernetesRoleResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesRoleResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubernetesRoleResources = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("axhceuwsijykgjlc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("gfpcyqmbiagbokrj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("ceyngkhpxsgxmoyc")
    public suspend fun roleStatus(`value`: Either<String, RoleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("fyscnoqgrqbxowrq")
    public fun roleStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    /**
     * @param value Role status.
     */
    @JvmName("eeiebtgmvxaoxkql")
    public fun roleStatus(`value`: RoleStatus) {
        val toBeMapped = Either.ofRight<String, RoleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleStatus = mapped
    }

    internal fun build(): KubernetesRoleArgs = KubernetesRoleArgs(
        deviceName = deviceName,
        hostPlatform = hostPlatform,
        kind = kind,
        kubernetesClusterInfo = kubernetesClusterInfo,
        kubernetesRoleResources = kubernetesRoleResources,
        name = name,
        resourceGroupName = resourceGroupName,
        roleStatus = roleStatus,
    )
}
