@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin as asymmetricEncryptedSecretResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MECRole].
 */
@PulumiTagMarker
public class MECRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MECRoleArgs = MECRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MECRoleArgsBuilder.() -> Unit) {
        val builder = MECRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MECRole {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.MECRole(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MECRole(builtJavaResource)
    }
}

/**
 * MEC role.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mecRole = new AzureNative.DataBoxEdge.MECRole("mecRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewMECRole(ctx, "mecRole", &databoxedge.MECRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.MECRole;
 * import com.pulumi.azurenative.databoxedge.MECRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mecRole = new MECRole("mecRole", MECRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:MECRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 */
public class MECRole internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.MECRole,
) : KotlinCustomResource(javaResource, MECRoleMapper) {
    /**
     * Activation key of the MEC.
     */
    public val connectionString: Output<AsymmetricEncryptedSecretResponse>?
        get() = javaResource.connectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> asymmetricEncryptedSecretResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Controller Endpoint.
     */
    public val controllerEndpoint: Output<String>?
        get() = javaResource.controllerEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Role type.
     * Expected value is 'MEC'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Unique Id of the Resource.
     */
    public val resourceUniqueId: Output<String>?
        get() = javaResource.resourceUniqueId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Role status.
     */
    public val roleStatus: Output<String>
        get() = javaResource.roleStatus().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Role
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MECRoleMapper : ResourceMapper<MECRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.MECRole::class == javaResource::class

    override fun map(javaResource: Resource): MECRole = MECRole(
        javaResource as
            com.pulumi.azurenative.databoxedge.MECRole,
    )
}

/**
 * @see [MECRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MECRole].
 */
public suspend fun mecRole(name: String, block: suspend MECRoleResourceBuilder.() -> Unit):
    MECRole {
    val builder = MECRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MECRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mecRole(name: String): MECRole {
    val builder = MECRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
