@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.MonitoringConfigArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.MetricConfigurationArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.MetricConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The metric setting details for the role
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### PutMonitoringConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoringConfig = new AzureNative.DataBoxEdge.MonitoringConfig("monitoringConfig", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         MetricConfigurations = new[]
 *         {
 *             new AzureNative.DataBoxEdge.Inputs.MetricConfigurationArgs
 *             {
 *                 CounterSets = new[]
 *                 {
 *                     new AzureNative.DataBoxEdge.Inputs.MetricCounterSetArgs
 *                     {
 *                         Counters = new[]
 *                         {
 *                             new AzureNative.DataBoxEdge.Inputs.MetricCounterArgs
 *                             {
 *                                 Name = "test",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MdmAccount = "test",
 *                 MetricNameSpace = "test",
 *                 ResourceId = "test",
 *             },
 *         },
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         RoleName = "testrole",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewMonitoringConfig(ctx, "monitoringConfig", &databoxedge.MonitoringConfigArgs{
 * 			DeviceName: pulumi.String("testedgedevice"),
 * 			MetricConfigurations: []databoxedge.MetricConfigurationArgs{
 * 				{
 * 					CounterSets: databoxedge.MetricCounterSetArray{
 * 						{
 * 							Counters: databoxedge.MetricCounterArray{
 * 								{
 * 									Name: pulumi.String("test"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					MdmAccount:      pulumi.String("test"),
 * 					MetricNameSpace: pulumi.String("test"),
 * 					ResourceId:      pulumi.String("test"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			RoleName:          pulumi.String("testrole"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.MonitoringConfig;
 * import com.pulumi.azurenative.databoxedge.MonitoringConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoringConfig = new MonitoringConfig("monitoringConfig", MonitoringConfigArgs.builder()
 *             .deviceName("testedgedevice")
 *             .metricConfigurations(Map.ofEntries(
 *                 Map.entry("counterSets", Map.of("counters", Map.of("name", "test"))),
 *                 Map.entry("mdmAccount", "test"),
 *                 Map.entry("metricNameSpace", "test"),
 *                 Map.entry("resourceId", "test")
 *             ))
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .roleName("testrole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:MonitoringConfig myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{roleName}/monitoringConfig/default
 * ```
 * @property deviceName The device name.
 * @property metricConfigurations The metrics configuration details
 * @property resourceGroupName The resource group name.
 * @property roleName The role name.
 */
public data class MonitoringConfigArgs(
    public val deviceName: Output<String>? = null,
    public val metricConfigurations: Output<List<MetricConfigurationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.MonitoringConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.MonitoringConfigArgs =
        com.pulumi.azurenative.databoxedge.MonitoringConfigArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .metricConfigurations(
                metricConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringConfigArgs].
 */
@PulumiTagMarker
public class MonitoringConfigArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var metricConfigurations: Output<List<MetricConfigurationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleName: Output<String>? = null

    /**
     * @param value The device name.
     */
    @JvmName("fqjkciulbrgcujbm")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The metrics configuration details
     */
    @JvmName("pxwpifacmbhrbivy")
    public suspend fun metricConfigurations(`value`: Output<List<MetricConfigurationArgs>>) {
        this.metricConfigurations = value
    }

    @JvmName("hqlsduvnstydisig")
    public suspend fun metricConfigurations(vararg values: Output<MetricConfigurationArgs>) {
        this.metricConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The metrics configuration details
     */
    @JvmName("jwixiyuatuxkqbiw")
    public suspend fun metricConfigurations(values: List<Output<MetricConfigurationArgs>>) {
        this.metricConfigurations = Output.all(values)
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("odvqqfxylasdobyu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("ootiusjflyvcepjh")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("nibeebgidcgtilsg")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The metrics configuration details
     */
    @JvmName("cmginpgcyudmhuvf")
    public suspend fun metricConfigurations(`value`: List<MetricConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricConfigurations = mapped
    }

    /**
     * @param argument The metrics configuration details
     */
    @JvmName("ixxhnvhfhfuqiuhr")
    public suspend
    fun metricConfigurations(argument: List<suspend MetricConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricConfigurations = mapped
    }

    /**
     * @param argument The metrics configuration details
     */
    @JvmName("wbxvubhaiivldunn")
    public suspend fun metricConfigurations(
        vararg
        argument: suspend MetricConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MetricConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricConfigurations = mapped
    }

    /**
     * @param argument The metrics configuration details
     */
    @JvmName("ueecqhrwfkvmgyxb")
    public suspend
    fun metricConfigurations(argument: suspend MetricConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metricConfigurations = mapped
    }

    /**
     * @param values The metrics configuration details
     */
    @JvmName("gkhwsamnojrjuowh")
    public suspend fun metricConfigurations(vararg values: MetricConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricConfigurations = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ctmjfqjkcekvvqqd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("olslkqlvbvvkyrwj")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    internal fun build(): MonitoringConfigArgs = MonitoringConfigArgs(
        deviceName = deviceName,
        metricConfigurations = metricConfigurations,
        resourceGroupName = resourceGroupName,
        roleName = roleName,
    )
}
