@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.AzureContainerInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ClientAccessRightResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.UserAccessRightResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.databoxedge.kotlin.outputs.AzureContainerInfoResponse.Companion.toKotlin as azureContainerInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ClientAccessRightResponse.Companion.toKotlin as clientAccessRightResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse.Companion.toKotlin as mountPointMapResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse.Companion.toKotlin as refreshDetailsResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.UserAccessRightResponse.Companion.toKotlin as userAccessRightResponseToKotlin

/**
 * Builder for [Share].
 */
@PulumiTagMarker
public class ShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ShareArgs = ShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ShareArgsBuilder.() -> Unit) {
        val builder = ShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Share {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.Share(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Share(builtJavaResource)
    }
}

/**
 * Represents a share on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### SharePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var share = new AzureNative.DataBoxEdge.Share("share", new()
 *     {
 *         AccessProtocol = "SMB",
 *         AzureContainerInfo = new AzureNative.DataBoxEdge.Inputs.AzureContainerInfoArgs
 *         {
 *             ContainerName = "testContainerSMB",
 *             DataFormat = "BlockBlob",
 *             StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1",
 *         },
 *         DataPolicy = "Cloud",
 *         Description = "",
 *         DeviceName = "testedgedevice",
 *         MonitoringStatus = "Enabled",
 *         Name = "smbshare",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ShareStatus = "Online",
 *         UserAccessRights = new[]
 *         {
 *             new AzureNative.DataBoxEdge.Inputs.UserAccessRightArgs
 *             {
 *                 AccessType = "Change",
 *                 UserId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewShare(ctx, "share", &databoxedge.ShareArgs{
 * 			AccessProtocol: pulumi.String("SMB"),
 * 			AzureContainerInfo: &databoxedge.AzureContainerInfoArgs{
 * 				ContainerName:              pulumi.String("testContainerSMB"),
 * 				DataFormat:                 pulumi.String("BlockBlob"),
 * 				StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1"),
 * 			},
 * 			DataPolicy:        pulumi.String("Cloud"),
 * 			Description:       pulumi.String(""),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			MonitoringStatus:  pulumi.String("Enabled"),
 * 			Name:              pulumi.String("smbshare"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ShareStatus:       pulumi.String("Online"),
 * 			UserAccessRights: []databoxedge.UserAccessRightArgs{
 * 				{
 * 					AccessType: pulumi.String("Change"),
 * 					UserId:     pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Share;
 * import com.pulumi.azurenative.databoxedge.ShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var share = new Share("share", ShareArgs.builder()
 *             .accessProtocol("SMB")
 *             .azureContainerInfo(Map.ofEntries(
 *                 Map.entry("containerName", "testContainerSMB"),
 *                 Map.entry("dataFormat", "BlockBlob"),
 *                 Map.entry("storageAccountCredentialId", "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/storageAccountCredentials/sac1")
 *             ))
 *             .dataPolicy("Cloud")
 *             .description("")
 *             .deviceName("testedgedevice")
 *             .monitoringStatus("Enabled")
 *             .name("smbshare")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .shareStatus("Online")
 *             .userAccessRights(Map.ofEntries(
 *                 Map.entry("accessType", "Change"),
 *                 Map.entry("userId", "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/users/user2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Share smbshare /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/shares/{name}
 * ```
 */
public class Share internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.Share,
) : KotlinCustomResource(javaResource, ShareMapper) {
    /**
     * Access protocol to be used by the share.
     */
    public val accessProtocol: Output<String>
        get() = javaResource.accessProtocol().applyValue({ args0 -> args0 })

    /**
     * Azure container mapping for the share.
     */
    public val azureContainerInfo: Output<AzureContainerInfoResponse>?
        get() = javaResource.azureContainerInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> azureContainerInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of IP addresses and corresponding access rights on the share(required for NFS protocol).
     */
    public val clientAccessRights: Output<List<ClientAccessRightResponse>>?
        get() = javaResource.clientAccessRights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        clientAccessRightResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Data policy of the share.
     */
    public val dataPolicy: Output<String>?
        get() = javaResource.dataPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description for the share.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Current monitoring status of the share.
     */
    public val monitoringStatus: Output<String>
        get() = javaResource.monitoringStatus().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Details of the refresh job on this share.
     */
    public val refreshDetails: Output<RefreshDetailsResponse>?
        get() = javaResource.refreshDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> refreshDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Share mount point to the role.
     */
    public val shareMappings: Output<List<MountPointMapResponse>>
        get() = javaResource.shareMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mountPointMapResponseToKotlin(args0) })
            })
        })

    /**
     * Current status of the share.
     */
    public val shareStatus: Output<String>
        get() = javaResource.shareStatus().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Share
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Mapping of users and corresponding access rights on the share (required for SMB protocol).
     */
    public val userAccessRights: Output<List<UserAccessRightResponse>>?
        get() = javaResource.userAccessRights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        userAccessRightResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object ShareMapper : ResourceMapper<Share> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.Share::class == javaResource::class

    override fun map(javaResource: Resource): Share = Share(
        javaResource as
            com.pulumi.azurenative.databoxedge.Share,
    )
}

/**
 * @see [Share].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Share].
 */
public suspend fun share(name: String, block: suspend ShareResourceBuilder.() -> Unit): Share {
    val builder = ShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Share].
 * @param name The _unique_ name of the resulting resource.
 */
public fun share(name: String): Share {
    val builder = ShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
