@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.EncryptionAlgorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represent the secrets intended for encryption with asymmetric key pair.
 * @property encryptionAlgorithm The algorithm used to encrypt "Value".
 * @property encryptionCertThumbprint Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
 * @property value The value of the secret.
 */
public data class AsymmetricEncryptedSecretArgs(
    public val encryptionAlgorithm: Output<Either<String, EncryptionAlgorithm>>,
    public val encryptionCertThumbprint: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs =
        com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs.builder()
            .encryptionAlgorithm(
                encryptionAlgorithm.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .encryptionCertThumbprint(encryptionCertThumbprint?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AsymmetricEncryptedSecretArgs].
 */
@PulumiTagMarker
public class AsymmetricEncryptedSecretArgsBuilder internal constructor() {
    private var encryptionAlgorithm: Output<Either<String, EncryptionAlgorithm>>? = null

    private var encryptionCertThumbprint: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("qdyolyojtcfrbsch")
    public suspend fun encryptionAlgorithm(`value`: Output<Either<String, EncryptionAlgorithm>>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
     */
    @JvmName("ysaqucbdeqdwxmip")
    public suspend fun encryptionCertThumbprint(`value`: Output<String>) {
        this.encryptionCertThumbprint = value
    }

    /**
     * @param value The value of the secret.
     */
    @JvmName("rocakxtwkmlbboxy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("uutvwyqngniwpdmc")
    public suspend fun encryptionAlgorithm(`value`: Either<String, EncryptionAlgorithm>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("bvnbtickwgxgumoy")
    public fun encryptionAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("mubdkrgbtsjeutwl")
    public fun encryptionAlgorithm(`value`: EncryptionAlgorithm) {
        val toBeMapped = Either.ofRight<String, EncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
     */
    @JvmName("wnvvwqwusndapfjw")
    public suspend fun encryptionCertThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionCertThumbprint = mapped
    }

    /**
     * @param value The value of the secret.
     */
    @JvmName("gcandnyunhvhgeyr")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AsymmetricEncryptedSecretArgs = AsymmetricEncryptedSecretArgs(
        encryptionAlgorithm = encryptionAlgorithm ?: throw PulumiNullFieldException("encryptionAlgorithm"),
        encryptionCertThumbprint = encryptionCertThumbprint,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
