@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetOrderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 */
public data class GetOrderPlainArgs(
    public val deviceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetOrderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetOrderPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetOrderPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderPlainArgs].
 */
@PulumiTagMarker
public class GetOrderPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The device name.
     */
    @JvmName("ebbljdftwcigmhtw")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tdhcmhmdubkffqgb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOrderPlainArgs = GetOrderPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
