@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.ImageRepositoryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Image repository credential.
 * @property imageRepositoryUrl Image repository url (e.g.: mcr.microsoft.com).
 * @property password Repository user password.
 * @property userName Repository user name.
 */
public data class ImageRepositoryCredentialArgs(
    public val imageRepositoryUrl: Output<String>,
    public val password: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val userName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.ImageRepositoryCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.ImageRepositoryCredentialArgs =
        com.pulumi.azurenative.databoxedge.inputs.ImageRepositoryCredentialArgs.builder()
            .imageRepositoryUrl(imageRepositoryUrl.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRepositoryCredentialArgs].
 */
@PulumiTagMarker
public class ImageRepositoryCredentialArgsBuilder internal constructor() {
    private var imageRepositoryUrl: Output<String>? = null

    private var password: Output<AsymmetricEncryptedSecretArgs>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Image repository url (e.g.: mcr.microsoft.com).
     */
    @JvmName("xofmhwgfcheimknj")
    public suspend fun imageRepositoryUrl(`value`: Output<String>) {
        this.imageRepositoryUrl = value
    }

    /**
     * @param value Repository user password.
     */
    @JvmName("pruxkngbqaxwfxde")
    public suspend fun password(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.password = value
    }

    /**
     * @param value Repository user name.
     */
    @JvmName("cjuwdpramopfvmcb")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Image repository url (e.g.: mcr.microsoft.com).
     */
    @JvmName("rmgsiqotnbuseigw")
    public suspend fun imageRepositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRepositoryUrl = mapped
    }

    /**
     * @param value Repository user password.
     */
    @JvmName("nbqxckxgweejfwqm")
    public suspend fun password(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument Repository user password.
     */
    @JvmName("kxrtjwyagscfknsv")
    public suspend fun password(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value Repository user name.
     */
    @JvmName("efnluygsvnrnxmhm")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ImageRepositoryCredentialArgs = ImageRepositoryCredentialArgs(
        imageRepositoryUrl = imageRepositoryUrl ?: throw PulumiNullFieldException("imageRepositoryUrl"),
        password = password,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
