@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.IoTDeviceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Metadata of IoT device/IoT Edge device to be configured.
 * @property authentication Encrypted IoT device/IoT edge device connection string.
 * @property deviceId ID of the IoT device/edge device.
 * @property ioTHostHub Host name for the IoT hub associated to the device.
 * @property ioTHostHubId Id for the IoT hub associated to the device.
 */
public data class IoTDeviceInfoArgs(
    public val authentication: Output<AuthenticationArgs>? = null,
    public val deviceId: Output<String>,
    public val ioTHostHub: Output<String>,
    public val ioTHostHubId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.IoTDeviceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.IoTDeviceInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.IoTDeviceInfoArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceId(deviceId.applyValue({ args0 -> args0 }))
            .ioTHostHub(ioTHostHub.applyValue({ args0 -> args0 }))
            .ioTHostHubId(ioTHostHubId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IoTDeviceInfoArgs].
 */
@PulumiTagMarker
public class IoTDeviceInfoArgsBuilder internal constructor() {
    private var authentication: Output<AuthenticationArgs>? = null

    private var deviceId: Output<String>? = null

    private var ioTHostHub: Output<String>? = null

    private var ioTHostHubId: Output<String>? = null

    /**
     * @param value Encrypted IoT device/IoT edge device connection string.
     */
    @JvmName("msfrkeolmbgyrbwl")
    public suspend fun authentication(`value`: Output<AuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value ID of the IoT device/edge device.
     */
    @JvmName("gpsbxddexlojjttt")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value Host name for the IoT hub associated to the device.
     */
    @JvmName("uutsncbiqgqmwmbh")
    public suspend fun ioTHostHub(`value`: Output<String>) {
        this.ioTHostHub = value
    }

    /**
     * @param value Id for the IoT hub associated to the device.
     */
    @JvmName("hrecbnrkkluameuo")
    public suspend fun ioTHostHubId(`value`: Output<String>) {
        this.ioTHostHubId = value
    }

    /**
     * @param value Encrypted IoT device/IoT edge device connection string.
     */
    @JvmName("luwsmuayfwlqxdhf")
    public suspend fun authentication(`value`: AuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Encrypted IoT device/IoT edge device connection string.
     */
    @JvmName("sapktrqqodcxxpuk")
    public suspend fun authentication(argument: suspend AuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = AuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value ID of the IoT device/edge device.
     */
    @JvmName("dvmufqadqqkhxssk")
    public suspend fun deviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value Host name for the IoT hub associated to the device.
     */
    @JvmName("enngvmdxhuieeukv")
    public suspend fun ioTHostHub(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ioTHostHub = mapped
    }

    /**
     * @param value Id for the IoT hub associated to the device.
     */
    @JvmName("keldqnferdtjurjj")
    public suspend fun ioTHostHubId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioTHostHubId = mapped
    }

    internal fun build(): IoTDeviceInfoArgs = IoTDeviceInfoArgs(
        authentication = authentication,
        deviceId = deviceId ?: throw PulumiNullFieldException("deviceId"),
        ioTHostHub = ioTHostHub ?: throw PulumiNullFieldException("ioTHostHub"),
        ioTHostHubId = ioTHostHubId,
    )
}
