@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.MetricConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Metric configuration.
 * @property counterSets Host name for the IoT hub associated to the device.
 * @property mdmAccount The MDM account to which the counters should be pushed.
 * @property metricNameSpace The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
 * @property resourceId The Resource ID on which the metrics should be pushed.
 */
public data class MetricConfigurationArgs(
    public val counterSets: Output<List<MetricCounterSetArgs>>,
    public val mdmAccount: Output<String>? = null,
    public val metricNameSpace: Output<String>? = null,
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.MetricConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.MetricConfigurationArgs =
        com.pulumi.azurenative.databoxedge.inputs.MetricConfigurationArgs.builder()
            .counterSets(
                counterSets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mdmAccount(mdmAccount?.applyValue({ args0 -> args0 }))
            .metricNameSpace(metricNameSpace?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricConfigurationArgs].
 */
@PulumiTagMarker
public class MetricConfigurationArgsBuilder internal constructor() {
    private var counterSets: Output<List<MetricCounterSetArgs>>? = null

    private var mdmAccount: Output<String>? = null

    private var metricNameSpace: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Host name for the IoT hub associated to the device.
     */
    @JvmName("fuwaiwjjbqjivuit")
    public suspend fun counterSets(`value`: Output<List<MetricCounterSetArgs>>) {
        this.counterSets = value
    }

    @JvmName("nwkmdmxyeuxadadb")
    public suspend fun counterSets(vararg values: Output<MetricCounterSetArgs>) {
        this.counterSets = Output.all(values.asList())
    }

    /**
     * @param values Host name for the IoT hub associated to the device.
     */
    @JvmName("lrbjbjgnmlcykisa")
    public suspend fun counterSets(values: List<Output<MetricCounterSetArgs>>) {
        this.counterSets = Output.all(values)
    }

    /**
     * @param value The MDM account to which the counters should be pushed.
     */
    @JvmName("gniqluiksnkdghml")
    public suspend fun mdmAccount(`value`: Output<String>) {
        this.mdmAccount = value
    }

    /**
     * @param value The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
     */
    @JvmName("dhqocqmeoowwvbht")
    public suspend fun metricNameSpace(`value`: Output<String>) {
        this.metricNameSpace = value
    }

    /**
     * @param value The Resource ID on which the metrics should be pushed.
     */
    @JvmName("xntjohahpoxfqbts")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Host name for the IoT hub associated to the device.
     */
    @JvmName("xhjypuyxvhgemgkr")
    public suspend fun counterSets(`value`: List<MetricCounterSetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.counterSets = mapped
    }

    /**
     * @param argument Host name for the IoT hub associated to the device.
     */
    @JvmName("btvvlnrtripnrgjf")
    public suspend fun counterSets(argument: List<suspend MetricCounterSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricCounterSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.counterSets = mapped
    }

    /**
     * @param argument Host name for the IoT hub associated to the device.
     */
    @JvmName("glmltsalysgfmioy")
    public suspend fun counterSets(vararg argument: suspend MetricCounterSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricCounterSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.counterSets = mapped
    }

    /**
     * @param argument Host name for the IoT hub associated to the device.
     */
    @JvmName("fyadjkitgegknpxe")
    public suspend fun counterSets(argument: suspend MetricCounterSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricCounterSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.counterSets = mapped
    }

    /**
     * @param values Host name for the IoT hub associated to the device.
     */
    @JvmName("dycjkdfljruhmsqh")
    public suspend fun counterSets(vararg values: MetricCounterSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.counterSets = mapped
    }

    /**
     * @param value The MDM account to which the counters should be pushed.
     */
    @JvmName("qedrwdympjfwofus")
    public suspend fun mdmAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mdmAccount = mapped
    }

    /**
     * @param value The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
     */
    @JvmName("uktlrlcobkspqitt")
    public suspend fun metricNameSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNameSpace = mapped
    }

    /**
     * @param value The Resource ID on which the metrics should be pushed.
     */
    @JvmName("chyhrddwsgvxkykw")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): MetricConfigurationArgs = MetricConfigurationArgs(
        counterSets = counterSets ?: throw PulumiNullFieldException("counterSets"),
        mdmAccount = mdmAccount,
        metricNameSpace = metricNameSpace,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
