@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The mapping between a particular client IP and the type of access client has on the NFS share.
 * @property accessPermission Type of access to be allowed for the client.
 * @property client IP of the client.
 */
public data class ClientAccessRightResponse(
    public val accessPermission: String,
    public val client: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ClientAccessRightResponse):
            ClientAccessRightResponse = ClientAccessRightResponse(
            accessPermission = javaType.accessPermission(),
            client = javaType.client(),
        )
    }
}
