@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Compute role.
 * @property computeResource Resource allocation
 * @property hostPlatform Host OS supported by the IoT role.
 * @property hostPlatformType Platform where the Iot runtime is hosted.
 * @property id The path ID that uniquely identifies the object.
 * @property ioTDeviceDetails IoT device metadata to which data box edge device needs to be connected.
 * @property ioTEdgeAgentInfo Iot edge agent details to download the agent and bootstrap iot runtime.
 * @property ioTEdgeDeviceDetails IoT edge device to which the IoT role needs to be configured.
 * @property kind Role type.
 * Expected value is 'IOT'.
 * @property name The object name.
 * @property roleStatus Role status.
 * @property shareMappings Mount points of shares in role(s).
 * @property systemData Metadata pertaining to creation and last modification of Role
 * @property type The hierarchical type of the object.
 */
public data class GetIoTRoleResult(
    public val computeResource: ComputeResourceResponse? = null,
    public val hostPlatform: String,
    public val hostPlatformType: String,
    public val id: String,
    public val ioTDeviceDetails: IoTDeviceInfoResponse,
    public val ioTEdgeAgentInfo: IoTEdgeAgentInfoResponse? = null,
    public val ioTEdgeDeviceDetails: IoTDeviceInfoResponse,
    public val kind: String,
    public val name: String,
    public val roleStatus: String,
    public val shareMappings: List<MountPointMapResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetIoTRoleResult):
            GetIoTRoleResult = GetIoTRoleResult(
            computeResource = javaType.computeResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.ComputeResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostPlatform = javaType.hostPlatform(),
            hostPlatformType = javaType.hostPlatformType(),
            id = javaType.id(),
            ioTDeviceDetails = javaType.ioTDeviceDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin(args0)
            }),
            ioTEdgeAgentInfo = javaType.ioTEdgeAgentInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTEdgeAgentInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ioTEdgeDeviceDetails = javaType.ioTEdgeDeviceDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
            name = javaType.name(),
            roleStatus = javaType.roleStatus(),
            shareMappings = javaType.shareMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
