@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kubernetes storage class info.
 * @property name Storage class name.
 * @property posixCompliant If provisioned storage is posix compliant.
 * @property type Storage class type.
 */
public data class KubernetesRoleStorageClassInfoResponse(
    public val name: String,
    public val posixCompliant: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesRoleStorageClassInfoResponse):
            KubernetesRoleStorageClassInfoResponse = KubernetesRoleStorageClassInfoResponse(
            name = javaType.name(),
            posixCompliant = javaType.posixCompliant(),
            type = javaType.type(),
        )
    }
}
